/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.mercedesbenzbank;

import de.derrichter.finance.websync.institute._archiv.mercedesbenzbank.WebUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;

public class WebAuth {
    public static HtmlPage loginWithHTMLUnit(String responseLogin, String responsePassword, WebClient syncWebClient, String Unterkonto, Class<?> externalLogger, Class<?> ExternalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        HtmlPage pageLogin = null;
        HtmlButton submitLogin = null;
        HtmlPage postLoginPage = null;
        String pageLoginXML = null;
        String postLoginXML = null;
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:MercedesBenz] " + getLogMethod + "MercedesBenz-Login aufrufen ... (GET " + "https://www.mercedes-benz-bank.de/intrade/cms/TAOB_Gesamtobligo.html" + ")");
            try {
                pageLogin = (HtmlPage)syncWebClient.getPage("https://www.mercedes-benz-bank.de/intrade/cms/TAOB_Gesamtobligo.html");
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "pageLogin: " + pageLogin);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (pageLogin == null) {
                throw new Exception("Die Login-Seite konnte nicht aufgerufen werden!");
            }
            pageLoginXML = pageLogin.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(pageLoginXML, (Page)pageLogin, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                HtmlForm formLogin = pageLogin.getFormByName("form");
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "formLogin: " + formLogin);
                formLogin.getInputByName("form:customerNumber").setValue(responseLogin);
                formLogin.getInputByName("form:pin").setValue(responsePassword);
                submitLogin = formLogin.getButtonByName("form:btnLogin");
            }
            catch (Exception error) {
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:MercedesBenz] " + getLogMethod + "Login-Form wird abgesendet ...");
            try {
                postLoginPage = (HtmlPage)submitLogin.click();
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "postLoginPage: " + postLoginPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (postLoginPage == null) {
                throw new Exception("Die Login-Folgeseite konnte nicht aufgerufen werden!");
            }
            postLoginXML = postLoginPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(postLoginXML, (Page)postLoginPage, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                if (error.equals("MercedesBenzAccountUnlocked")) {
                    return null;
                }
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (postLoginXML.contains("PIN \u00e4ndern") && postLoginXML.contains("Bitte beachten Sie")) {
                DialogWarn.invoke((Object)DialogWarn, "Meldung der Mercedes-Benz Bank AG:\n\n\nVergabe einer neuen PIN notwendig. Loggen Sie sich im Online-Banking ein um dies zu erledigen", "institutlogo-mercedesbenzbank.png");
                isSelfException = true;
                throw new Exception("Vergabe einer neuen PIN notwendig. Loggen Sie sich im Online-Banking ein um dies zu erledigen");
            }
            if (postLoginXML.contains("Auftragskennwort neu vergeben")) {
                isSelfException = true;
                throw new Exception("Vergabe eines neuen Auftragskennwort notwendig. Loggen Sie sich im Online-Banking ein um dies zu erledigen");
            }
            if (postLoginXML.contains("Nur noch eine E-Mailadresse von Ihrem Online-Banking entfernt")) {
                String infoMessage = "Seit dem 14. Oktober 2017 ist die Hinterlegung einer g\u00fcltigen E-Mailadresse Voraussetzung f\u00c3\u0152r die Nutzung Ihres Online-Bankings und des Mercedes-Benz Bank Postfachs.\nBitte beachten Sie, dass die Nutzung Ihres Online-Bankings daher seit dem 01.07.2018 nicht mehr m\u00f6glich bis diese hinterlegt wurde.\n\n";
                String errorMessage = "Loggen Sie sich im Online-Banking ein und hinterlegen Sie dort Ihre E-Mailadresse und best\u00e4tigen Sie die Angabe mit Ihrem Auftragskennwort";
                DialogWarn.invoke((Object)DialogWarn, "Meldung der Mercedes-Benz Bank AG:\n\n\n" + infoMessage + errorMessage, "institutlogo-mercedesbenzbank.png");
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (postLoginXML.contains("action=\"/intrade/login/login.jsf\"")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            return postLoginPage;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Fehlermeldung des Systems: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static void logout(WebClient syncWebClient, String optionalOptions, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            String logoutURL = "https://www.mercedes-benz-bank.de/intrade/logout";
            HtmlPage postLogoutPage = null;
            String postLogoutPageXML = null;
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "GET: " + logoutURL);
            try {
                postLogoutPage = (HtmlPage)syncWebClient.getPage(logoutURL);
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "PostLogoutPage: " + postLogoutPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            postLogoutPageXML = postLogoutPage.asXml();
            try {
                WebUtils.checkResponse(postLogoutPageXML, (Page)postLogoutPage, ExternalLogger, ExternalProgressMonitor, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (!postLogoutPageXML.contains("Erneut anmelden")) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:MercedesBenz] " + getLogMethod + "Logout bei der '" + "Mercedes-Benz Bank AG" + "' war erfolgreich");
            syncWebClient.close();
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:MercedesBenz] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

