/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.fidorbank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.HTMLUnitUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static String COOKIE_DETECT_PATH = "#usercentrics-root,div[data-testid='uc-default-banner']";
    static String COOKIE_ACCEPT_PATH = "button[data-testid='uc-save-button']";
    static String LOADER_CATCHSTRING = "DummyCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//div[contains(@class,'loading')]//parent::div[contains(@class,'success') and not(contains(@class,'d-none'))] | //div[(contains(@class,'spinner') or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[1];
    protected static String[] xpathSearchStringExclusion = new String[7];
    private static String LastErrorMessage = "";

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[contains(@class,'alert') and not(contains(.,'Hinweis'))]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Erfolgreich angemeldet";
        WebUtils.xpathSearchStringExclusion[1] = "Sie haben sich erfolgreich abgemeldet";
        WebUtils.xpathSearchStringExclusion[2] = "Laufzeit und Kosten: Dieser Auftrag ist ";
        WebUtils.xpathSearchStringExclusion[3] = "Die \u00dcberweisung war erfolgreich";
        WebUtils.xpathSearchStringExclusion[4] = "Falls der Ausf\u00fchrungstermin auf ein Wochenende oder einen Feiertag f\u00e4llt";
        WebUtils.xpathSearchStringExclusion[5] = "Hinweis";
        WebUtils.xpathSearchStringExclusion[6] = "Verf\u00fcgbarkeit Kontoausz\u00fcge";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String logIdent = "[WebSync:FidorBank] ";
        String longName = "Fidor Bank AG";
        try {
            try {
                String warnDialogText = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'well-warning')]")).getText();
                DialogWarn.invoke((Object)DialogWarn, "Meldung der Fidor Bank AG:\n(Diese muss manuell im Onlinebanking best\u00e4tigt werden)\n\n\n" + warnDialogText, "institutlogo-fidorbank.png");
                warnDialogText = StringCharUtils.shrinkString(warnDialogText.replace(" x ", ""));
                throw new Exception(warnDialogText);
            }
            catch (NoSuchElementException noBestSign) {
                WebUtils.setSerchStrings();
                WebUtils.setSerchExclusionStrings();
                SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-fidorbank.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static void checkHTMLUnitResponseHasError(String pageResponse, Page currentPage, Class<?> externalLogger, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:FidorBank] ";
        String longName = "Fidor Bank AG";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            HTMLUnitUtils.checkHTMLUnitWebClientResponse(pageResponse, currentPage, logIdent, longName, "institutlogo-fidorbank.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    static WebDriver checkForBankingApp(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        String getLogMethod = "[waitBankingApp] ";
        String tanArt = "BankingApp";
        String detectAppAuthPath = "//div[contains(.,'den Login in der Fidor Smart Banking App')]";
        String detectVerifiPath = "//div[contains(.,'Der Vorgang wird nun validiert')]";
        String detectAbortPath = "//p[contains(.,'Der Vorgang wurde abgebrochen')]";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectAppAuthPath)));
                LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "Warte auf Banking-App Freigabe ...");
                MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                int rounds = 0;
                Thread.sleep(3000L);
                boolean showWaiting = true;
                boolean validating = false;
                while (true) {
                    WebElement waiterCheckElement = null;
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAppAuthPath));
                        showWaiting = true;
                    }
                    catch (NoSuchElementException noBestSign) {
                        showWaiting = false;
                    }
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectVerifiPath));
                        validating = true;
                    }
                    catch (NoSuchElementException noBestSign) {
                        validating = false;
                    }
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAbortPath));
                        isSelfException = true;
                        throw new Exception("Banking-App Authentifizierung: Der Vorgang wurde abgebrochen");
                    }
                    catch (NoSuchElementException noBestSign) {
                        if (showWaiting) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                            Thread.sleep(3000L);
                        } else if (validating) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "Validierung des Vorgang im gange ...");
                            MonitorLog.invoke((Object)MonitorLog, "Validierung des Vorgang im gange ...");
                            SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                        } else {
                            showWaiting = false;
                            validating = false;
                        }
                        if (++rounds >= 39) {
                            isSelfException = true;
                            throw new Exception("Banking-App Authentifizierung auch nach 120 Sekunden nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                            continue;
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                        if (showWaiting || validating) continue;
                    }
                    break;
                }
            }
            catch (TimeoutException noAuth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + tanArt + "' wird NICHT (direkt) abgefragt oder hat sich ge\u00e4ndert? mache weiter ...");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            isSelfException = true;
            throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    static WebDriver checkTANRequest(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkTANRequest] ";
        String tanArt = "TAN-Request";
        String detectTANrequestPath = "//a[contains(.,'Zur TAN Freigabe')]";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANrequestPath)));
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "tANrequestButton", detectTANrequestPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + tanArt + "TAN-Request gestartet ... untersuche Tan-Abfrage ...");
            }
            catch (TimeoutException noAuth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + tanArt + "' wird NICHT (direkt) abgefragt oder hat sich ge\u00e4ndert? mache weiter ...");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    static WebDriver checkForMTAN(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkForMTAN] ";
        String tanArt = "mobileTAN";
        String detectTANformPath = "//label[contains(.,'mTAN:')]";
        String secTextPath = "//div[contains(@class,'otp-form-content')]//p";
        String tanInputPath = "//input[@id='northbound_action_otp']";
        String submitTanPath = "//input[@name='confirm']";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                WebElement tanForm = seleniumWebDriver.findElement(By.xpath((String)detectTANformPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "tanForm: " + tanForm);
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "tanForm", detectTANformPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")"))).getText().trim();
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "secText: " + secText);
                boolean retryInput = false;
                do {
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-fidorbank.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:FidorBank] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTan", submitTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfterTanResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebElement checkWrongTAN = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'input-hint--error')]"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "checkWrongTAN: " + checkWrongTAN);
                        DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der Fidor Bank AG:\n\n\nDie eingegebene " + tanArt + " ist falsch.", "institutlogo-fidorbank.png");
                        retryInput = true;
                    }
                    catch (NoSuchElementException | TimeoutException wrongTAN) {
                        retryInput = false;
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterTanResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (retryInput);
            }
            catch (TimeoutException noTANauth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt oder wurde umgebaut? mache weiter ...");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    public static void setLastErrorMessage(String lastErrorMessage) {
        LastErrorMessage = lastErrorMessage;
    }

    public static String checkResponse(String responseContentAsString, Page responsePage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        String getLogMethod = "[checkResponse] ";
        boolean isSelfException = false;
        try {
            String errorResponse = null;
            String errorMessage = null;
            if (responseContentAsString.contains("alert alert-recaptcha_error alert-flash")) {
                errorMessage = "Anmeldung bei der Fidor Bank aufgrund von ReCaptcha nicht mehr m\u00f6glich!\n\nBei der Bank die Abschaffung oder eine Alternative verlangen!\n\nDurch die Politik von Fidor ist eine Anbindung hier somit nicht mehr geplant!";
                DialogError.invoke((Object)DialogError, "Fehlermeldung der Fidor Bank AG:\n\n\n" + errorMessage, "institutlogo-fidorbank.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("alert alert-alert alert-flash")) {
                errorResponse = ((DomNode)responsePage).asXml();
                errorMessage = WebUtils.formErrorMessage(errorResponse, externalLogger, externalProgressMonitor);
                if (responseContentAsString.contains("sich anmelden oder registrieren")) {
                    errorMessage = errorMessage + "\n\ndies bedeutet:\nDie Sitzung wurde von der Bank beendet. Bitte melden Sie sich erneut an";
                }
                DialogError.invoke((Object)DialogError, "Fehlermeldung der Fidor Bank AG:\n\n\n" + errorMessage, "institutlogo-fidorbank.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("alert-heading")) {
                if (responseContentAsString.contains("Die \u00dcberweisung war erfolgreich")) {
                    return null;
                }
                errorResponse = ((DomNode)responsePage).asXml();
                errorMessage = WebUtils.formTransferErrorMessage(errorResponse, externalLogger, externalProgressMonitor);
                if (responseContentAsString.contains("sich anmelden oder registrieren")) {
                    errorMessage = errorMessage + "\n\ndies bedeutet:\nDie Sitzung wurde von der Bank beendet. Bitte melden Sie sich erneut an";
                }
                DialogError.invoke((Object)DialogError, "Fehlermeldung der Fidor Bank AG:\n\n\n" + errorMessage, "institutlogo-fidorbank.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("alert alert-error")) {
                errorMessage = StringCharUtils.shrinkString(((DomElement)((HtmlPage)responsePage).getFirstByXPath("//div[@class='alert alert-error']")).getTextContent().replace("mehr Details", ""));
                if (LastErrorMessage.equals(errorMessage)) {
                    return null;
                }
                LastErrorMessage = errorMessage;
                LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "Warnungs-Nachricht der Bank: " + errorMessage);
                MonitorLog.invoke((Object)MonitorLog, "Warnungs-Nachricht der Bank: " + errorMessage);
                return null;
            }
            if (responseContentAsString.contains("Sie nun Ihre 6 stellige FIN") && responseContentAsString.contains("Fidor Identification Number")) {
                isSelfException = true;
                throw new Exception("Auf dem Internetauftritt muss Ihre pers\u00f6nliche FIN (Fidor Identification Number) vergeben werden");
            }
            if (responseContentAsString.contains("sich anmelden oder registrieren")) {
                isSelfException = true;
                throw new Exception("Die Sitzung wurde von der Bank beendet. Bitte melden Sie sich erneut an");
            }
            if (responseContentAsString.contains("AGB") && responseContentAsString.contains("verstanden und akzeptiert")) {
                isSelfException = true;
                throw new Exception("Auf dem Internetauftritt muss die AGB der Fidor Bank AG neu akzeptiert werden");
            }
            if (responseContentAsString.contains("Der Gesetzgeber verpflichtet uns die Adressen unserer Kunden")) {
                isSelfException = true;
                throw new Exception("Auf dem Internetauftritt muss Ihre Adresse best\u00e4tigt werden");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formErrorMessage(String contentStringToParse, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            int ErrorTextIDXStart = 0;
            int ErrorTextIDXend = 0;
            ErrorTextIDXStart = contentStringToParse.indexOf("alert alert-alert alert-flash");
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "ErrorTextIDXStart: " + ErrorTextIDXStart);
            ErrorTextIDXStart = contentStringToParse.indexOf("\">", ErrorTextIDXStart) + 2;
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "ErrorTextIDXStart: " + ErrorTextIDXStart);
            ErrorTextIDXend = contentStringToParse.indexOf("</div>", ErrorTextIDXStart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "ErrorTextIDXend: " + ErrorTextIDXend);
            String ErrorText = contentStringToParse.substring(ErrorTextIDXStart, ErrorTextIDXend);
            LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "ErrorText (unformatiert): " + ErrorText);
            String formErrorText = StringEscapeUtils.unescapeHtml4((String)ErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkString(formErrorText);
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formTransferErrorMessage(String contentStringToParse, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formTransferErrorMessage] ";
        try {
            int errorTextIDXStart = 0;
            int errorTextIDXend = 0;
            errorTextIDXStart = contentStringToParse.indexOf("alert-heading");
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
            errorTextIDXStart = contentStringToParse.indexOf("<p>", errorTextIDXStart) + 3;
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
            errorTextIDXend = contentStringToParse.indexOf("</ul>", errorTextIDXStart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "ErrorTextIDXend: " + errorTextIDXend);
            String ErrorText = contentStringToParse.substring(errorTextIDXStart, errorTextIDXend);
            LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "ErrorText (unformatiert): " + ErrorText);
            String formErrorText = ErrorText.replaceAll("</li>", "; ");
            formErrorText = formErrorText.replaceAll("</p>", " ");
            formErrorText = StringEscapeUtils.unescapeHtml4((String)formErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkString(formErrorText);
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formTransferErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

