/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.fidorbank;

import de.derrichter.finance.websync.institute._archiv.fidorbank.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public class WebPush {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void transfer(WebDriver seleniumWebDriver, String iban, String gegenkontoName, String gegenkontoIBAN, String gegenkontoBIC, String betrag, String verwendungszweck, String termin, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        String mTAN;
        String currentSourceToView;
        String pageResponse;
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        Method DialogAskMTAN = externalDialogInterface.getMethod("askMTANforTransaction", String.class, String.class, String.class);
        String getLogMethod = "[sendTrans] ";
        LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Originale Auftragsdaten wie vom Programm \u00fcbergeben (Auftragskonto, IBAN, BIC und Betrag sind aber schon getrimmt)");
        LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Auftragskonto (IBAN):             " + iban);
        LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Gegenkonto (IBAN):                " + gegenkontoIBAN);
        LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Gegenkonto (BIC):                 " + gegenkontoBIC);
        LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Auftragsdaten (Betrag):           " + betrag);
        LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Auftragsdaten (Verwendungszweck): " + verwendungszweck);
        LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Auftragsdaten (Termin):           " + termin);
        iban = iban.replaceAll("\\s+", "").trim();
        gegenkontoIBAN = gegenkontoIBAN.replaceAll("\\s+", "").trim();
        gegenkontoBIC = gegenkontoBIC.replaceAll("\\s+", "").trim();
        betrag = betrag.replaceAll("[^\\d,]", "").trim();
        verwendungszweck = verwendungszweck.replace("\u00c4", "Ae").replace("\u00e4", "ae").replace("\u00d6", "Oe").replace("\u00f6", "oe").replace("\u00dc", "Ue").replace("\u00fc", "ue").replace("\u00df", "ss").trim();
        boolean isSelfException = false;
        try {
            MonitorLog.invoke((Object)MonitorLog, "SEPA-\u00dcberweisungsformular aufrufen, ausf\u00fcllen und mTAN anfordern ...");
            LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "SEPA-\u00dcberweisungsformular aufrufen ... (GET " + "https://banking.fidor.de/smart-account/bank_transfers/new" + ")");
            try {
                seleniumWebDriver.get("https://banking.fidor.de/smart-account/bank_transfers/new");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "transpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String transferPageXML = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(transferPageXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            String cookieDetectPath = "#usercentrics-root,#focus-lock-id";
            String cookieAcceptPath = "button[data-testid='uc-save-button']";
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:FidorBank] ", "Fidor Bank AG", "institutlogo-fidorbank.png", cookieDetectPath, cookieAcceptPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            if (!transferPageXML.contains("Kontonummer: ")) {
                throw new Exception("Auf der Seite konnte kein Auftragskonto-Feld gefunden werden. Falsche oder andere Seite");
            }
            try {
                String auftragskonto = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)("//div[contains(.,'Kontonummer: " + iban + "')]"))).getText());
                LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Auftragskonto: " + auftragskonto);
            }
            catch (NoSuchElementException accError) {
                isSelfException = true;
                throw new Exception("Das hinterlegte Auftragskonto entspricht nicht Ihrer IBAN in der SEPA-\u00dcberweisung");
            }
            try {
                seleniumWebDriver.findElement(By.name((String)"bank_transfer[rec_holder]")).sendKeys(new CharSequence[]{gegenkontoName});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                seleniumWebDriver.findElement(By.name((String)"bank_transfer[rec_iban]")).sendKeys(new CharSequence[]{gegenkontoIBAN});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                seleniumWebDriver.findElement(By.name((String)"bank_transfer[amount_pre_decimal_place]")).sendKeys(new CharSequence[]{betrag.split(",")[0].trim()});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                seleniumWebDriver.findElement(By.name((String)"bank_transfer[amount_decimal_place]")).sendKeys(new CharSequence[]{betrag.split(",")[1].replaceAll("[A-Za-z]+", "").replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll("&euro;", "").replaceAll("EUR", "").replaceAll("\u20ac", "").replaceAll("\\s", "").trim()});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                seleniumWebDriver.findElement(By.name((String)"bank_transfer[subject]")).sendKeys(new CharSequence[]{verwendungszweck});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des formTransfer-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + error.getMessage());
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "\u00dcberweisung-Form wird abgesendet und die Daten gepr\u00fcft ...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "checkTransfer", "//input[@value='\u00dcberweisung pr\u00fcfen']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            pageResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 45);
            TakesScreenshot screenshotObject = null;
            String screenShotBASE64 = null;
            String tempScreenshotPath = null;
            currentSourceToView = null;
            try {
                screenshotObject = (TakesScreenshot)seleniumWebDriver;
                File screenShotFile = (File)screenshotObject.getScreenshotAs(OutputType.FILE);
                tempScreenshotPath = System.getProperty("java.io.tmpdir") + File.separator + "syncWebClient_ScreenCaptureTmp" + File.separator + "santander" + String.valueOf(new Date().getTime()) + "-transfer.png";
                FileUtils.moveFile((File)screenShotFile, (File)new File(tempScreenshotPath));
                String screenShotRawBASE64 = (String)screenshotObject.getScreenshotAs(OutputType.BASE64);
                LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "screenShotRawBASE64: " + screenShotRawBASE64);
                screenShotBASE64 = "data:image/png;base64," + screenShotRawBASE64;
                LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "screenShotBASE64: " + screenShotBASE64);
                currentSourceToView = tempScreenshotPath;
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Sichtkontrollseite konnte nicht erstellt werden; Errorseite vermutlich erstellt: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 55);
            LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "\u00dcberweisungs-Best\u00e4tigung wird abgesendet und die mTAN angefordert ...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "confirmTransfer", "//input[@value='Best\u00e4tigen']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            pageResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            mTAN = null;
            String userInfoText = "Sie bekommen in K\u00fcrze eine mTAN per SMS auf Ihr Mobiltelefon zugeschickt.\nBitte geben Sie diese ein, um die Transaktion zu best\u00e4tigen.\n\nEmpf\u00e4nger: " + gegenkontoName + "\nEmpf\u00e4nger IBAN: " + gegenkontoIBAN + "\nAuftragsdatum: " + new SimpleDateFormat("dd.MM.yyyy").format(new Date().getTime()) + "\nBetrag: " + betrag + "" + System.getProperty("line.separator");
            mTAN = (String)DialogAskMTAN.invoke((Object)DialogAskMTAN, userInfoText, currentSourceToView, "institutlogo-fidorbank.png");
        }
        catch (Exception error) {
            if (!isSelfException) throw new Exception("Exception beim Ausf\u00fchren des Auftrags: " + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception(error.getMessage());
        }
        try {
            FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
        }
        catch (Exception error) {
            LogError.invoke((Object)LogError, "[WebSync:FidorBank] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error.getMessage());
        }
        MonitorLog.invoke((Object)MonitorLog, "Authentifiziere Auftrag mit angegebener mTAN ...");
        try {
            seleniumWebDriver.findElement(By.id((String)"tan")).sendKeys(new CharSequence[]{mTAN});
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
        }
        catch (Exception error) {
            isSelfException = true;
            throw new Exception("mTAN-Eingabefeld konnte nicht gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        catch (InvocationTargetException error) {
            try {
                isSelfException = true;
                if (ExceptionUtils.getRootCauseStackTrace((Throwable)error)[0].contains("OperationCanceledException")) {
                    throw new Exception("Angabe der mTAN vom Benutzer abgebrochen (OperationCanceledException)");
                }
                LogError.invoke((Object)LogError, "[WebSync:FidorBank] " + getLogMethod + "DialogAskMTAN fehlerhaft:" + ExceptionUtils.getStackTrace((Throwable)error));
                throw new Exception("DialogAskMTAN fehlerhaft: " + error.getMessage());
                catch (Exception error2) {
                    isSelfException = true;
                    throw new Exception("Angabe der mTAN vom Benutzer abgebrochen oder DialogAskMTAN fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error2));
                }
            }
            catch (Throwable throwable) {
                try {
                    FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                    throw throwable;
                }
                catch (Exception error3) {
                    LogError.invoke((Object)LogError, "[WebSync:FidorBank] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error3.getMessage());
                }
                throw throwable;
            }
        }
        try {
            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "sendTransfer", "//input[@value='mTAN best\u00e4tigen']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
        }
        catch (Exception error) {
            isSelfException = true;
            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        String postTransferSendXML = seleniumWebDriver.getPageSource();
        LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "\u00dcberweisung mit mTAN wird abgesendet ...");
        try {
            WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            isSelfException = true;
            throw new Exception(error.getMessage());
        }
        if (!postTransferSendXML.contains("\u00dcberweisung war erfolgreich")) {
            LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "Ergebnisseite zum unbest\u00e4tigtem Auftrag:\n" + postTransferSendXML);
            isSelfException = true;
            throw new Exception("Auftrag konnte nicht best\u00e4tigt werden. Manuelle Pr\u00fcfung und Erledigt-Kennzeichnung erforderlich! (Bitte dem Entwickler im Forum melden)");
        }
        LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "Auftrag ausgef\u00fchrt und best\u00e4tigt");
    }
}

