/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.fidorbank;

import de.derrichter.finance.websync.institute._archiv.fidorbank.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "Umsatz\u00fcbersicht aufrufen ... (GET " + "https://banking.fidor.de/smart-account/transactions" + ")");
            try {
                seleniumWebDriver.get("https://banking.fidor.de/smart-account/transactions");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "transpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageTransResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageTransResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            try {
                String amountText = seleniumWebDriver.findElement(By.xpath((String)"//th[contains(.,'Kontostand am')]//following-sibling::td")).getText().trim();
                LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "amountText: " + amountText);
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Kontostand' fehlgeschlagen: " + error.getMessage());
            }
            try {
                String availableAmountText = seleniumWebDriver.findElement(By.xpath((String)"//th[contains(.,'Verf\u00fcgbarer Betrag')]//following-sibling::td")).getText().trim();
                LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "availableAmountText: " + availableAmountText);
                availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Verf\u00fcgbarer Betrag' fehlgeschlagen: " + error.getMessage());
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "Amount: " + amount);
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "availableAmount: " + availableAmount);
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:FidorBank] ", "Fidor Bank AG", "institutlogo-fidorbank.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            int csvLinksCountBefore = 0;
            int csvLinksCountAfter = 0;
            int waiterRound = 1;
            List csvLinksElementsBefore = seleniumWebDriver.findElements(By.xpath((String)"//a[contains(@href,'download_export')]"));
            if (csvLinksElementsBefore != null) {
                csvLinksCountBefore = csvLinksElementsBefore.size();
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "csvLinksCountBefore: " + csvLinksCountBefore);
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "csvLinksElementsBefore: " + csvLinksElementsBefore);
            String csvDownloadLink = "https://banking.fidor.de/smart-account/transactions.csv?from=FDFMFJ&time_selection=from_to&to=TDTMTJ".replace("FDFMFJ", fromDateSimple).replace("TDTMTJ", toDateSimple);
            LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "CSV laden: " + csvDownloadLink);
            boolean localTest = false;
            File downloadedFile = null;
            String doctext = null;
            String filetype = "";
            try {
                seleniumWebDriver.get(csvDownloadLink);
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "transactions-page: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "Kontoauszug angefordert, warte auf Bereitstellung...");
                MonitorLog.invoke((Object)MonitorLog, "Kontoauszug angefordert, warte auf Bereitstellung...");
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:FidorBank] ", "Fidor Bank AG", "institutlogo-fidorbank.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                do {
                    Thread.sleep(3000L);
                    seleniumWebDriver.get("https://banking.fidor.de/smart-account/transactions");
                    List csvLinksElementsAfter = seleniumWebDriver.findElements(By.xpath((String)"//a[contains(@href,'download_export')]"));
                    if (csvLinksElementsAfter != null) {
                        csvLinksCountAfter = csvLinksElementsAfter.size();
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "csvLinksAfter Round#" + waiterRound + ": Found '" + csvLinksCountAfter + "' ->" + csvLinksElementsAfter);
                } while (csvLinksCountAfter <= csvLinksCountBefore && ++waiterRound <= 20);
                if (waiterRound >= 20) {
                    isSelfException = true;
                    throw new Exception("Der CSV-Kontoauszug wurde auch nach 60 Sekunden Wartezeit nicht generiert. Bitte online pr\u00fcfen und der Fidor Bank melden");
                }
                if (localTest) {
                    String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                    downloadedFile = new File(docFixTempFilePath);
                }
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                try {
                    String detectPath = "//div[@class='popup' and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
                    String messagePath = detectPath + "//div[@class='popup__content']";
                    String closePath = detectPath + "//div[@class='reject cross-popup']";
                    boolean hasAbortButton = false;
                    do {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                        wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                        String formWarnText = "";
                        List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                        for (WebElement headline : allHeadlines) {
                            String headlinetext = headline.getText();
                            formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:FidorBank] ", headlinetext, externalLogger) + " ";
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "warnText: " + formWarnText);
                        if (!formWarnText.contains("Freigabeverfahren verwalten")) {
                            DialogWarn.invoke((Object)DialogWarn, "Meldung der Fidor Bank AG:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://auth.fidor.de/session/new" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-fidorbank.png");
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                        try {
                            wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                        }
                        catch (NoSuchElementException | TimeoutException notAborterr) {
                            hasAbortButton = false;
                            isSelfException = true;
                            throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                        }
                        hasAbortButton = true;
                        LogWarn.invoke((Object)LogWarn, "[WebSync:FidorBank] Meldung(en) der Bank: " + formWarnText);
                        MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    } while (hasAbortButton);
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
                }
                do {
                    if (!localTest) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "csvExport", "//a[contains(@href,'download_export.csv')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    filetype = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                    if (filetype.toLowerCase().equals("txt") || filetype.toLowerCase().equals("htm") || filetype.toLowerCase().equals("html") || filetype.toLowerCase().equals("asp") || filetype.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Der CSV-Kontoauszug konnte nicht generiert bzw. geladen werden\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String fileResponse = "";
            String fileencoding = "windows-1252";
            fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
            LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
            if (!fileencoding.equals("UTF-8")) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:FidorBank] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                doctext = new String(filebytes, System.getProperty("file.encoding"));
            } else {
                doctext = fileResponse;
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + filetype + "-Rechnung (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
            if (doctext.contains("<html") || doctext.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            if (!localTest) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:FidorBank] " + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
            }
            String[] dataResponse = new String[]{doctext, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(doctext, '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double Betrag = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][3]).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll("\u20ac", "").replaceAll("&euro;", "").replaceAll("EUR", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (matrixArrayData[i][1].startsWith("Bonusgutschrift")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Bonusgutschrift");
                    } else if (matrixArrayData[i][1].startsWith("\u00dcberweisung")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("\u00dcberweisung");
                    } else if (matrixArrayData[i][1].startsWith("Ueberweisung")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("\u00dcberweisung");
                    } else if (matrixArrayData[i][1].startsWith("Auszahlung")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Auszahlung");
                    } else if (matrixArrayData[i][1].startsWith("Geldsendung")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Geldsendung");
                    } else if (matrixArrayData[i][1].startsWith("Lastschrift")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Lastschrift");
                    } else if (matrixArrayData[i][1].startsWith("Transaktionskosten")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Transaktionskosten");
                    } else if (matrixArrayData[i][1].startsWith("DTA-Gutschrift")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("DTA-Gutschrift");
                    } else if (matrixArrayData[i][1].startsWith("Gutschrift")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Gutschrift");
                    } else if (matrixArrayData[i][1].startsWith("Sollzinsen")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Sollzinsen");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][1])) {
                        String purp = matrixArrayData[i][1];
                        if (purp.startsWith("\u00dcberweisung")) {
                            purp = purp.substring(11);
                        } else if (purp.startsWith("Ueberweisung")) {
                            purp = purp.substring(12);
                        } else if (purp.startsWith("Auszahlung")) {
                            purp = purp.substring(10);
                        } else if (purp.startsWith("Geldsendung")) {
                            purp = purp.substring(11);
                        } else if (purp.startsWith("Lastschrift")) {
                            purp = purp.substring(11);
                        } else if (purp.startsWith("Transaktionskosten")) {
                            purp = purp.substring(18);
                        } else if (purp.startsWith("DTA-Gutschrift")) {
                            purp = purp.substring(13);
                        } else if (purp.startsWith("Gutschrift")) {
                            purp = purp.substring(10);
                        } else if (purp.startsWith("Sollzinsen")) {
                            purp = purp.substring(10);
                        }
                        purp = purp.trim();
                        if (purp.contains(" BIC: ") || purp.contains(" BIC ")) {
                            int startPurp = purp.indexOf(" BIC") + 7;
                            purp = (startPurp = purp.indexOf(" ", startPurp) + 1) <= 1 ? "" : purp.substring(startPurp).trim();
                        } else if (purp.contains(" IBAN: ") || purp.contains(" IBAN ")) {
                            int startPurp = purp.indexOf(" IBAN") + 7;
                            purp = (startPurp = purp.indexOf(" ", startPurp) + 1) <= 1 ? "" : purp.substring(startPurp).trim();
                        }
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purp.replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String gegenkontoName = "";
                    String gegenkontoNummer = "";
                    String gegenkontoBLZ = "";
                    String iban = "";
                    String bic = "";
                    String kommentar = "";
                    if ((matrixArrayData[i][2].indexOf("Empf\u00e4nger") >= 0 || matrixArrayData[i][2].indexOf("Empfaenger") >= 0 || matrixArrayData[i][2].indexOf("Absender") >= 0) && (matrixArrayData[i][2].indexOf("Konto") >= 0 && matrixArrayData[i][2].indexOf("BLZ") >= 0 || matrixArrayData[i][2].indexOf("IBAN") >= 0 && matrixArrayData[i][2].indexOf("BIC") >= 0 || matrixArrayData[i][2].indexOf(", IBAN:") >= 0 || matrixArrayData[i][2].indexOf(" IBAN ") >= 0)) {
                        String[] gegenkontoArray2;
                        String[] gegenkontoArray1;
                        if (matrixArrayData[i][2].indexOf("Konto") >= 0 && matrixArrayData[i][2].indexOf("BLZ") >= 0) {
                            gegenkontoArray1 = matrixArrayData[i][2].split("Konto");
                            if (matrixArrayData[i][2].indexOf("Empf\u00e4nger") >= 0) {
                                gegenkontoName = StringCharUtils.shrinkWhitespaces(gegenkontoArray1[0].replaceAll("Empf\u00e4nger", "").replaceAll(":", "").replaceAll(",", ""));
                            } else if (matrixArrayData[i][2].indexOf("Empfaenger") >= 0) {
                                gegenkontoName = StringCharUtils.shrinkWhitespaces(gegenkontoArray1[0].replaceAll("Empfaenger", "").replaceAll(":", "").replaceAll(",", ""));
                            } else if (matrixArrayData[i][2].indexOf("Absender") >= 0) {
                                gegenkontoName = StringCharUtils.shrinkWhitespaces(gegenkontoArray1[0].replaceAll("Absender", "").replaceAll(":", "").replaceAll(",", ""));
                            }
                            gegenkontoArray2 = gegenkontoArray1[1].split("BLZ");
                            gegenkontoNummer = StringCharUtils.shrinkWhitespaces(gegenkontoArray2[0].replaceAll(":", "").replaceAll(",", ""));
                            gegenkontoBLZ = StringCharUtils.shrinkWhitespaces(gegenkontoArray2[1].replaceAll(":", "").replaceAll(",", ""));
                        } else if (matrixArrayData[i][2].indexOf("IBAN ") >= 0 || matrixArrayData[i][2].indexOf("IBAN: ") >= 0) {
                            String ibanValue;
                            gegenkontoArray1 = matrixArrayData[i][2].split("IBAN");
                            if (matrixArrayData[i][2].indexOf("Empf\u00e4nger") >= 0) {
                                gegenkontoName = StringCharUtils.shrinkWhitespaces(gegenkontoArray1[0].replaceAll("Empf\u00e4nger", "").replaceAll(":", "").replaceAll(",", ""));
                            } else if (matrixArrayData[i][2].indexOf("Empfaenger") >= 0) {
                                gegenkontoName = StringCharUtils.shrinkWhitespaces(gegenkontoArray1[0].replaceAll("Empfaenger", "").replaceAll(":", "").replaceAll(",", ""));
                            } else if (matrixArrayData[i][2].indexOf("Absender") >= 0) {
                                gegenkontoName = StringCharUtils.shrinkWhitespaces(gegenkontoArray1[0].replaceAll("Absender", "").replaceAll(":", "").replaceAll(",", ""));
                            }
                            if (matrixArrayData[i][2].indexOf("BIC ") >= 0 || matrixArrayData[i][2].indexOf("BIC: ") >= 0) {
                                gegenkontoArray2 = gegenkontoArray1[1].split("BIC");
                                ibanValue = StringCharUtils.shrinkWhitespaces(gegenkontoArray2[0].replaceAll(":", "").replaceAll(",", ""));
                                if (ibanValue.startsWith("DE")) {
                                    gegenkontoNummer = ibanValue.substring(12, 22);
                                    gegenkontoBLZ = ibanValue.substring(4, 12);
                                } else {
                                    gegenkontoNummer = ibanValue;
                                }
                                iban = ibanValue;
                                bic = StringCharUtils.shrinkWhitespaces(gegenkontoArray2[1].replaceAll(":", "").replaceAll(",", ""));
                            } else {
                                ibanValue = StringCharUtils.shrinkWhitespaces(gegenkontoArray1[1].replaceAll(":", "").replaceAll(",", ""));
                                if (ibanValue.startsWith("DE")) {
                                    gegenkontoNummer = ibanValue.substring(12, 22);
                                    gegenkontoBLZ = ibanValue.substring(4, 12);
                                } else {
                                    gegenkontoNummer = ibanValue;
                                }
                                iban = ibanValue;
                            }
                        }
                    } else {
                        kommentar = matrixArrayData[i][2];
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(iban);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(bic);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(kommentar);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:FidorBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "needTransDateAndOrValutaFusion", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("FidorBank", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

