/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.advanziabank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;

public class WebUtils_Tg {
    public static String checkResponse(String responseContentAsString, Page responsePage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        String getLogMethod = "[checkResponse] ";
        boolean isSelfException = false;
        try {
            String ErrorMessage = null;
            if (responseContentAsString.contains("class=\"error\"")) {
                ErrorMessage = WebUtils_Tg.formErrorMessage(responseContentAsString, externalLogger, externalProgressMonitor);
                DialogError.invoke((Object)DialogError, "Fehlermeldung der Advanzia Bank S.A.:\n\n\n" + ErrorMessage, "institutlogo-advanziabank.png");
                ErrorMessage = StringCharUtils.shrinkString(ErrorMessage);
                if (responseContentAsString.contains("Die Bild-Zeichen sind nicht korrekt")) {
                    return null;
                }
                isSelfException = true;
                throw new Exception(ErrorMessage);
            }
            if (responseContentAsString.contains("class=\"popup_contentinboxapp\"")) {
                isSelfException = true;
                throw new Exception("Die Webseite stellt wohl eine PopUp-Nachricht dar. Melden Sie sich dort manuell an und reagieren Sie auf diese.");
            }
            if (responseContentAsString.contains("Zu Ihrer Sicherheit wurden Sie automatisch abgemeldet")) {
                isSelfException = true;
                throw new Exception("Die Sitzung wurde von der Bank beendet. Bitte melden Sie sich erneut an");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            StringWriter sw = new StringWriter();
            error.printStackTrace(new PrintWriter(sw));
            LogError.invoke((Object)LogError, "[WebSync:Advanzia] " + getLogMethod + "checkResponse fehlerhaft:\n" + sw.toString());
            throw new Exception("checkResponse fehlerhaft: " + error.getMessage());
        }
    }

    public static String formErrorMessage(String contentStringToParse, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            int errorIDXstart = contentStringToParse.indexOf("class=\"error\"");
            LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "ErrorIDXstart: " + errorIDXstart);
            int errorTextIDXStart = contentStringToParse.indexOf("<span", errorIDXstart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
            int errorTextIDXend = contentStringToParse.indexOf("</div>", errorTextIDXStart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "ErrorTextIDXend: " + errorTextIDXend);
            String errorText = contentStringToParse.substring(errorTextIDXStart, errorTextIDXend);
            LogTrace.invoke((Object)LogTrace, "[WebSync:Advanzia] " + getLogMethod + "ErrorText (unformatiert): " + errorText);
            String formErrorText = errorText.replaceAll("\t", "");
            formErrorText = errorText.replaceAll("\n", "");
            formErrorText = errorText.replaceAll("\r\n", "");
            formErrorText = errorText.replaceAll("\r\n ", "");
            formErrorText = errorText.replaceAll("\n ", "");
            formErrorText = errorText.replaceAll("\r", "");
            formErrorText = errorText.replaceAll("\r ", "");
            formErrorText = errorText.replaceAll("  ", "");
            formErrorText = errorText.replaceAll("\\(", "\n\\(");
            formErrorText = errorText.replaceAll("\\)", "\\)\n");
            formErrorText = errorText.replaceAll(": ", ":\n");
            formErrorText = StringCharUtils.shrinkString(formErrorText);
            formErrorText = StringEscapeUtils.unescapeHtml4((String)formErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkWhitespaces(formErrorText);
            formErrorText = formErrorText.trim();
            LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "ErrorText (formatiert):\n" + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            StringWriter sw = new StringWriter();
            error.printStackTrace(new PrintWriter(sw));
            LogError.invoke((Object)LogError, "[WebSync:Advanzia] " + getLogMethod + "formErrorMessage fehlerhaft:\n" + sw.toString());
            throw new Exception("formErrorMessage fehlerhaft: " + error.getMessage());
        }
    }
}

