/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.advanziabank;

import de.derrichter.finance.websync.institute._archiv.advanziabank.WebUtils_Tg;
import de.derrichter.finance.websync.utils.StringCharUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;

public class WebAuth_Tg {
    public static HtmlPage loginWithHTMLUnit(String responseLogin, String responsePassword, WebClient syncWebClient, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogCaptcha = externalDialogInterface.getMethod("askCaptcha", InputStream.class, String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        HtmlPage pageLogin = null;
        DomElement submitLogin = null;
        String gwtContentXML = null;
        String postLoginResponse = null;
        Object pageLoginResponse = null;
        if (responsePassword.length() < 6 || responsePassword.length() > 60) {
            DialogWarn.invoke((Object)DialogWarn, "Das Advanzia-Passwort muss 6 bis 60-stellig sein", "institutlogo-advanziabank.png");
            return null;
        }
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:Advanzia] " + getLogMethod + "Advanzia" + "-Login aufrufen ... (GET " + "https://mein.advanziakonto.com" + ")");
            try {
                pageLogin = (HtmlPage)syncWebClient.getPage("https://mein.advanziakonto.com");
                syncWebClient.waitForBackgroundJavaScript(5000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "pageLogin: " + pageLogin);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (pageLogin == null) {
                throw new Exception("Die Login-Seite konnte nicht aufgerufen werden!");
            }
            gwtContentXML = ((DomNode)pageLogin.getByXPath("//div[@class='contentboxapp']/descendant::*").get(0)).asXml();
            try {
                WebUtils_Tg.checkResponse(gwtContentXML, (Page)pageLogin, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            gwtContentXML = null;
            boolean trueCaptcha = false;
            do {
                String userCaptchaInput;
                try {
                    HtmlImage captchaImageObject = (HtmlImage)pageLogin.getFirstByXPath("//img[@class='gwt-Image']");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "CaptchaImageObject: " + captchaImageObject);
                    InputStream captchaImageResponse = captchaImageObject.getWebResponse(false).getContentAsStream();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "CaptchaImageResponse: " + captchaImageResponse);
                    userCaptchaInput = (String)DialogCaptcha.invoke((Object)DialogCaptcha, captchaImageResponse, "institutlogo-advanziabank.png");
                }
                catch (InvocationTargetException error) {
                    isSelfException = true;
                    if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                        throw new Exception("Abbruch der Captcha-Antwort durch Benutzer (OperationCanceledException)");
                    }
                    LogError.invoke((Object)LogError, "[WebSync:Advanzia] " + getLogMethod + "DialogCaptcha fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                    throw new Exception("DialogCaptcha fehlerhaft: " + error.getMessage());
                }
                catch (Exception error) {
                    throw new Exception("Fehler bei der Captcha-Abfrage oder Abbruch durch Benutzer (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    HtmlInput userField = (HtmlInput)pageLogin.getFirstByXPath("//input[@maxlength='13']");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "userField: " + userField);
                    userField.setValue(responseLogin);
                    HtmlInput passwordField = (HtmlInput)pageLogin.getFirstByXPath("//input[@type='password']");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "passwordField: " + passwordField);
                    passwordField.setValue(responsePassword);
                    List textInputFields = pageLogin.getByXPath("//input[@type='text']");
                    HtmlInput captchaField = (HtmlInput)textInputFields.get(textInputFields.size() - 1);
                    captchaField.setValue(userCaptchaInput);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "captchaField: " + captchaField);
                    submitLogin = (DomElement)pageLogin.getFirstByXPath("//button[@class='gwt-Button']");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "submitLogin: " + submitLogin);
                }
                catch (Exception error) {
                    throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                pageLogin = null;
                gwtContentXML = null;
                LogInfo.invoke((Object)LogInfo, "[WebSync:Advanzia] " + getLogMethod + "Login-Form wird abgesendet ...");
                try {
                    pageLogin = (HtmlPage)((HtmlElement)submitLogin).click();
                    syncWebClient.waitForBackgroundJavaScript(3000L);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "pageLogin: " + pageLogin);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                if (pageLogin == null) {
                    throw new Exception("Die Login-Folgeseite konnte nicht aufgerufen werden!");
                }
                gwtContentXML = ((DomNode)pageLogin.getByXPath("//div[@class='contentboxapp']/descendant::*").get(0)).asXml();
                try {
                    WebUtils_Tg.checkResponse(gwtContentXML, (Page)pageLogin, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    if (error.equals("AdvanziaAccountUnlocked")) {
                        return null;
                    }
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                if (gwtContentXML.indexOf("Die Bild-Zeichen sind nicht korrekt") != -1) continue;
                trueCaptcha = true;
            } while (!trueCaptcha);
            if (gwtContentXML.contains("type=\"password\"")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum\nGanze Seite zur Analyse:\n" + postLoginResponse + "gwtContentXML zur Analyse:\n" + gwtContentXML);
            }
            return pageLogin;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            throw new Exception("Fehlermeldung des Systems: " + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logout(WebClient syncWebClient, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            URL currentURL = syncWebClient.getCurrentWindow().getEnclosedPage().getUrl();
            String currentURLString = currentURL.toString();
            LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "currentURL: " + currentURLString);
            String logoutURL = currentURLString.substring(0, currentURLString.indexOf("#")) + "#logout";
            HtmlPage postLogoutPage = null;
            String postLogoutPageXML = null;
            LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "Get: " + logoutURL);
            try {
                postLogoutPage = (HtmlPage)syncWebClient.getPage(logoutURL);
                Thread.sleep(1500L);
                syncWebClient.waitForBackgroundJavaScript(5000L);
                postLogoutPage.refresh();
                Thread.sleep(1500L);
                syncWebClient.waitForBackgroundJavaScript(5000L);
                postLogoutPage = (HtmlPage)syncWebClient.getPage(logoutURL);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "PostLogoutPage: " + postLogoutPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            postLogoutPageXML = postLogoutPage.asXml();
            try {
                WebUtils_Tg.checkResponse(postLogoutPageXML, (Page)postLogoutPage, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (!postLogoutPageXML.contains("Vielen Dank f\u00fcr Ihren Besuch")) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:Advanzia] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Advanzia] " + getLogMethod + "Logout bei der '" + "Advanzia Bank S.A." + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:Advanzia] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

