/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.connector;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.ProxySelector;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSWebClientInit {
    private static final String LogIdent = "[WebSync:PhantomJSWebClientInit] ";
    private static WebDriver driver;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WebDriver connConfig(boolean lowssl, boolean js, boolean ignsslerr, boolean websec, boolean imgload, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, boolean appSysProxyUse, String appProxyHost, int appProxyPort, String appHttpsProxyHost, int appHttpsProxyPort, boolean appProxyAuthUse, String ProxyUser, String ProxyPass) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogWarn = ExternalLogger.getMethod("warn", String.class);
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method MonitorLog = ExternalProgressMonitor.getMethod("log", String.class);
        boolean isSelfException = false;
        try {
            DesiredCapabilities caps;
            block34: {
                ArrayList<String> cliArgs;
                block35: {
                    block36: {
                        int SysProxyFehler;
                        String SysProxyInfoHTTPS;
                        String SysProxyInfoHTTP;
                        block37: {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:PhantomJSWebClientInit] PhantomJS-Webclient wird vorbereitet ...");
                            String rawPhantomJSBinaryPath = System.getProperty("phantomjs.binary.path");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] Angegebener Pfad zur PhantomJS-Binary: " + rawPhantomJSBinaryPath);
                            if (StringCharUtils.isNullOrEmptyOrNothing(rawPhantomJSBinaryPath)) {
                                throw new Exception("Pfad zur PhantomJS-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"phantomjs.binary.path\", <Pfad zur Binary>);'");
                            }
                            File phantomJSBinary = new File(rawPhantomJSBinaryPath);
                            if (!phantomJSBinary.exists()) {
                                isSelfException = true;
                                throw new Exception("Pfad zur PhantomJS-Binary scheint nicht korrekt. (Existiert nicht) Bitte \u00fcberpr\u00fcfen Sie diesen.");
                            }
                            if (!phantomJSBinary.isFile()) {
                                isSelfException = true;
                                throw new Exception("Pfad zur PhantomJS-Binary scheint nicht korrekt. (Keine Datei) Bitte \u00fcberpr\u00fcfen Sie diesen.");
                            }
                            try {
                                if (!phantomJSBinary.canExecute()) {
                                    phantomJSBinary.setExecutable(true);
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] PhantomJS-Binary wurde erfolgreich als ausf\u00fcrbar markiert");
                                }
                            }
                            catch (Exception error1) {
                                isSelfException = true;
                                throw new Exception("PhantomJS-Binary konnte nicht auf Ausf\u00fchrbarkeit gepr\u00fcft oder gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error1));
                            }
                            String phantomJSBinaryPath = phantomJSBinary.getCanonicalPath();
                            String rawPhantomJSLogPath = System.getProperty("phantomjs.logfile.path");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] Angegebener Pfad zur PhantomJS-Logdatei: " + rawPhantomJSLogPath);
                            if (StringCharUtils.isNullOrEmptyOrNothing(rawPhantomJSLogPath)) {
                                throw new Exception("Pfad zur PhantomJS-Log ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"phantomjs.logfile.path\", <Pfad zum Logfile>);'");
                            }
                            File rawPhantomJSLog = new File(rawPhantomJSLogPath);
                            if (!rawPhantomJSLog.exists()) {
                                try {
                                    rawPhantomJSLog.createNewFile();
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    LogError.invoke((Object)LogError, "[WebSync:PhantomJSWebClientInit] PhantomJS-Logdatei existierte nicht und konnte aber auch nicht angelegt werden! \\u00dcberpr\u00fcfen Sie die Pfadangabe; Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                if (!rawPhantomJSLog.isFile()) throw new Exception("Pfad zur PhantomJS-Log scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                if (!rawPhantomJSLog.canWrite()) throw new Exception("Pfad zur PhantomJS-Log scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                if (!rawPhantomJSLog.canRead()) {
                                    throw new Exception("Pfad zur PhantomJS-Log scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                }
                            }
                            String phantomJSLogPath = rawPhantomJSLog.getCanonicalPath();
                            System.setProperty("webdriver.phantomjs.driver", phantomJSBinaryPath);
                            caps = new DesiredCapabilities();
                            cliArgs = new ArrayList<String>();
                            cliArgs.add("--ssl-protocol=any");
                            cliArgs.add("--local-url-access=false");
                            caps.setAcceptInsecureCerts(lowssl);
                            if (ignsslerr) {
                                cliArgs.add("--ignore-ssl-errors=true");
                            }
                            if (!websec) {
                                cliArgs.add("--web-security=false");
                            }
                            if (!imgload) {
                                cliArgs.add("--load-images=false");
                            }
                            caps.setCapability("phantomjs.binary.path", phantomJSBinaryPath);
                            cliArgs.add("--webdriver-logfile=" + phantomJSLogPath);
                            cliArgs.add("--webdriver-loglevel=WARN");
                            caps.setCapability("phantomjs.cli.args", cliArgs);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] es wird auf eine Proxy-Konfiguration gepr\u00fcft ...");
                            if (!appSysProxyUse && (appProxyHost == null || appProxyPort == -1 || appSysProxyUse) && (appHttpsProxyHost == null || appHttpsProxyPort == -1 || appSysProxyUse)) break block35;
                            LogInfo.invoke((Object)LogInfo, "[WebSync:PhantomJSWebClientInit] PhantomJS Proxy-Einstellungen setzen ...");
                            MonitorLog.invoke((Object)MonitorLog, "PhantomJS Proxy-Einstellungen setzen ...");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] Die Applikation nutzt den System-Proxy: " + appSysProxyUse);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTP-Proxy Host von der Applikation ist: " + appProxyHost);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTP-Proxy Port von der Applikation ist: " + appProxyPort);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTPS-Proxy Host von der Applikation ist: " + appHttpsProxyHost);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTPS-Proxy Port von der Applikation ist: " + appHttpsProxyPort);
                            if (!appSysProxyUse) break block36;
                            System.setProperty("java.net.useSystemProxies", "true");
                            SysProxyInfoHTTP = ProxySelector.getDefault().select(new URI("http://www.java.de")).get(0).toString();
                            SysProxyInfoHTTPS = ProxySelector.getDefault().select(new URI("https://www.mydrive.ch")).get(0).toString();
                            SysProxyFehler = 0;
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTP Proxy-Einstellung des Systems ist f\u00fcr Java: " + SysProxyInfoHTTP);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTPS Proxy-Einstellung des Systems ist f\u00fcr Java: " + SysProxyInfoHTTPS);
                            if (SysProxyInfoHTTP != "DIRECT" || SysProxyInfoHTTPS != "DIRECT") break block37;
                            MonitorLog.invoke((Object)MonitorLog, "Info-Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy im System eingetragen!");
                            LogInfo.invoke((Object)LogInfo, "[WebSync:PhantomJSWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy im System eingetragen!");
                            cliArgs.add("--proxy-type=none");
                            break block34;
                        }
                        String SysProxyHost = null;
                        int SysProxyPort = 0;
                        if (SysProxyInfoHTTP != "DIRECT") {
                            String[] SysProxyValuesString = SysProxyInfoHTTP.split(" @ ");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] SysProxyValuesString: " + SysProxyValuesString);
                            String SysProxyProtokol = SysProxyValuesString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] SysProxyProtokol: " + SysProxyProtokol);
                            String SysProxySetting = SysProxyValuesString[1];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] SysProxySetting: " + SysProxySetting);
                            String[] SysProxyString = SysProxySetting.split(":");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] SysProxyString: " + SysProxyString);
                            SysProxyHost = SysProxyString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTP-Proxy Host des Systems ist f\u00fcr Java: " + SysProxyHost);
                            SysProxyPort = Integer.parseInt(SysProxyString[1]);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTP-Proxy Port des Systems ist f\u00fcr Java: " + SysProxyPort);
                        } else {
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTP im System eingetragen!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:PhantomJSWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTP im System eingetragen!");
                            ++SysProxyFehler;
                        }
                        String SysHttpsProxyHost = null;
                        int SysHttpsProxyPort = 0;
                        if (SysProxyInfoHTTPS != "DIRECT") {
                            String[] SysHttpsProxyValuesString = SysProxyInfoHTTPS.split(" @ ");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] SysHttpsProxyValuesString: " + SysHttpsProxyValuesString);
                            String SysHttpsProxyProtokol = SysHttpsProxyValuesString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] SysHttpsProxyProtokol: " + SysHttpsProxyProtokol);
                            String SysHttpsProxySetting = SysHttpsProxyValuesString[1];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] SysHttpsProxySetting: " + SysHttpsProxySetting);
                            String[] SysHttpsProxyString = SysHttpsProxySetting.split(":");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] SysHttpsProxyString: " + SysHttpsProxyString);
                            SysHttpsProxyHost = SysHttpsProxyString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTPS-Proxy Host des Systems ist f\u00fcr Java: " + SysHttpsProxyHost);
                            SysHttpsProxyPort = Integer.parseInt(SysHttpsProxyString[1]);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] HTTPS-Proxy Port des Systems ist f\u00fcr Java: " + SysHttpsProxyPort);
                        } else {
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTPS im System eingetragen!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:PhantomJSWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTPS im System eingetragen!");
                            ++SysProxyFehler;
                        }
                        if (SysHttpsProxyHost != null) {
                            cliArgs.add("--proxy-type=http");
                            cliArgs.add("--proxy=" + SysHttpsProxyHost + ":" + SysHttpsProxyPort);
                            MonitorLog.invoke((Object)MonitorLog, "OK: Es wird der HTTPS-Proxy vom System benutzt");
                            LogInfo.invoke((Object)LogInfo, "[WebSync:PhantomJSWebClientInit] Es wird der HTTPS-Proxy vom System benutzt");
                            break block34;
                        } else if (SysProxyHost != null && SysProxyPort != -1) {
                            cliArgs.add("--proxy-type=http");
                            cliArgs.add("--proxy=" + SysProxyHost + ":" + SysProxyPort);
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Es wird der HTTP-Proxy vom System benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:PhantomJSWebClientInit] Es wird der HTTP-Proxy vom System benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                            break block34;
                        } else {
                            if (++SysProxyFehler != 3) throw new Exception("Systemproxy-Einstellungen verwenden ist gew\u00e4hlt: aber bei diesen fehlt offensichtlich ein Eintrag!");
                            MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: Es sieht so aus als w\u00fcrden Sie eigentlich keinen Proxy verwenden ...");
                            MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: ... entfernen Sie daher wom\u00f6glich einfach den Hacken der Proxykonfiguration ...");
                            MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: ... 'System-Einstellungen verwenden' in den Programm-Einstellungen, um diesen Fehler zu beheben");
                            throw new Exception("Systemproxy-Einstellungen verwenden ist gew\u00e4hlt: aber bei diesen fehlt offensichtlich ein Eintrag!");
                        }
                    }
                    if (appHttpsProxyHost != null && appHttpsProxyPort != -1 && !appSysProxyUse) {
                        cliArgs.add("--proxy-type=http");
                        cliArgs.add("--proxy=" + appHttpsProxyHost + ":" + appHttpsProxyPort);
                        MonitorLog.invoke((Object)MonitorLog, "OK: Es wird der HTTPS-Proxy von der Applikation benutzt");
                        LogInfo.invoke((Object)LogInfo, "[WebSync:PhantomJSWebClientInit] Es wird der HTTPS-Proxy von der Applikation benutzt");
                        break block34;
                    } else if (appProxyHost != null && appProxyPort != -1 && !appSysProxyUse) {
                        cliArgs.add("--proxy-type=http");
                        cliArgs.add("--proxy=" + appProxyHost + ":" + appProxyPort);
                        MonitorLog.invoke((Object)MonitorLog, "Warnung: Es wird der HTTP-Proxy von der Applikation benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                        LogWarn.invoke((Object)LogWarn, "[WebSync:PhantomJSWebClientInit] Es wird der HTTP-Proxy von der Applikation benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                    }
                    break block34;
                }
                if (appProxyHost != null && appProxyPort == -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTP-Proxy eingetragen aber die Port-Einstellung fehlt!");
                }
                if (appProxyHost == null && appProxyPort != -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTP-Proxy-Port eingetragen aber die Host-Einstellung fehlt!");
                }
                if (appHttpsProxyHost != null && appHttpsProxyPort == -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTPS-Proxy eingetragen aber die Port-Einstellung fehlt!");
                }
                if (appHttpsProxyHost == null && appHttpsProxyPort != -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTPS-Proxy-Port eingetragen aber die Host-Einstellung fehlt!");
                }
                cliArgs.add("--proxy-type=none");
                LogDebug.invoke((Object)LogDebug, "[WebSync:PhantomJSWebClientInit] ... es ist auf keine aktive Weise ein Proxy eingestellt");
            }
            driver = new PhantomJSDriver((Capabilities)caps);
            driver.manage().window().setSize(new Dimension(1920, 1080));
            driver.manage().window().maximize();
            LogInfo.invoke((Object)LogInfo, "[WebSync:PhantomJSWebClientInit] PhantomJS-Webclient wurde erfolgreich vorbereitet");
            return driver;
        }
        catch (Exception error) {
            try {
                driver.quit();
            }
            catch (Exception error1) {
                LogError.invoke((Object)LogError, "[WebSync:PhantomJSWebClientInit] WebDriver beenden fehlgeschlagen! Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:PhantomJSWebClientInit] Erstellen des phantomJSWebClient fehlgeschlagen! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("Erstellen des WebClient fehlgeschlagen! (siehe Meldungen im Log)");
        }
    }
}

