/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.connector;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.check.FirefoxVersion;
import de.derrichter.finance.websync.utils.webdrivertools.GeckoDriverUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.ProxySelector;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.RemoteWebDriver;

public class GeckoDriverWebClientInit {
    private static final String logIdent = "[WebSync:GeckoDriverWebClientInit] ";
    private static WebDriver driver;
    private static String rawGeckoDriverBinaryPath;
    private static final String rawGeckoDriverLogPath;
    private static final String rawFirefoxRootPath;
    private static final String rawFirefoxBinaryPath;
    private static String rawFirefoxDownloadsPath;
    private static final boolean forceUseAlterateBrowser;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WebDriver connConfig(boolean lowssl, boolean js, boolean websec, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, boolean appSysProxyUse, String appProxyHost, int appProxyPort, String appHttpsProxyHost, int appHttpsProxyPort, boolean appProxyAuthUse, String ProxyUser, String ProxyPass, boolean headlessMode, String profilePath, String loadExtention) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogWarn = ExternalLogger.getMethod("warn", String.class);
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method MonitorLog = ExternalProgressMonitor.getMethod("log", String.class);
        boolean isSelfException = false;
        try {
            Proxy proxy;
            FirefoxOptions options;
            block82: {
                block83: {
                    block84: {
                        int sysProxyFehler;
                        String sysProxyInfoHTTPS;
                        String sysProxyInfoHTTP;
                        block85: {
                            File rawFirefoxDownloadPath;
                            LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] GeckoDriver-Webclient wird vorbereitet ...");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Angegebener Pfad zur GeckoDriver-Binary: " + rawGeckoDriverBinaryPath);
                            if (StringCharUtils.isNullOrEmptyOrNothing(rawGeckoDriverBinaryPath)) {
                                throw new Exception("Pfad zur GeckoDriver-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"webdriver.gecko.driver\", <Pfad zur Binary>);'");
                            }
                            File geckoDriverBinary = new File(rawGeckoDriverBinaryPath);
                            if (!geckoDriverBinary.exists()) {
                                if (rawGeckoDriverBinaryPath.endsWith("hibiscus.scripting.geckodriver" + File.separator + "bin" + File.separator + "macos" + File.separator + "geckodriver")) {
                                    rawGeckoDriverBinaryPath = rawGeckoDriverBinaryPath.replace("macos", "macos64");
                                } else if (rawGeckoDriverBinaryPath.endsWith("hibiscus.scripting.geckodriver" + File.separator + "bin" + File.separator + "macos64" + File.separator + "geckodriver")) {
                                    rawGeckoDriverBinaryPath = rawGeckoDriverBinaryPath.replace("macos64", "macos");
                                } else if (rawGeckoDriverBinaryPath.endsWith("hibiscus.scripting.geckodriver" + File.separator + "bin" + File.separator + "macos-arm" + File.separator + "geckodriver")) {
                                    rawGeckoDriverBinaryPath = rawGeckoDriverBinaryPath.replace("macos-arm", "macos-aarch64");
                                } else if (rawGeckoDriverBinaryPath.endsWith("hibiscus.scripting.geckodriver" + File.separator + "bin" + File.separator + "macos-aarch64" + File.separator + "geckodriver")) {
                                    rawGeckoDriverBinaryPath = rawGeckoDriverBinaryPath.replace("macos-aarch64", "macos-arm");
                                }
                                geckoDriverBinary = new File(rawGeckoDriverBinaryPath);
                                if (!geckoDriverBinary.exists()) {
                                    isSelfException = true;
                                    throw new Exception("Pfad zur GeckoDriver-Binary scheint nicht korrekt. (Existiert nicht) Bitte \u00fcberpr\u00fcfen Sie diesen.");
                                }
                            }
                            if (!geckoDriverBinary.isFile()) {
                                isSelfException = true;
                                throw new Exception("Pfad zur GeckoDriver-Binary scheint nicht korrekt. (Keine Datei) Bitte \u00fcberpr\u00fcfen Sie diesen.");
                            }
                            try {
                                if (!geckoDriverBinary.canExecute()) {
                                    geckoDriverBinary.setExecutable(true);
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] GeckoDriver-Binary wurde erfolgreich als ausf\u00fcrbar markiert");
                                }
                            }
                            catch (Exception error1) {
                                isSelfException = true;
                                throw new Exception("GeckoDriver-Binary konnte nicht auf Ausf\u00fchrbarkeit gepr\u00fcft oder gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error1));
                            }
                            String firefoxDriverBinaryPath = geckoDriverBinary.getCanonicalPath();
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Angegebener Pfad zur GeckoDriver-Logdatei: " + rawGeckoDriverLogPath);
                            if (StringCharUtils.isNullOrEmptyOrNothing(rawGeckoDriverLogPath)) {
                                throw new Exception("Pfad zur GeckoDriver-Log ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"geckodriver.logfile.path\", <Pfad zum Logfile>);'");
                            }
                            File rawGeckoDriverLog = new File(rawGeckoDriverLogPath);
                            if (!rawGeckoDriverLog.exists()) {
                                try {
                                    rawGeckoDriverLog.createNewFile();
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    LogError.invoke((Object)LogError, "[WebSync:GeckoDriverWebClientInit] GeckoDriver-Logdatei existierte nicht und konnte aber auch nicht angelegt werden! \\u00dcberpr\u00fcfen Sie die Pfadangabe; Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                if (!rawGeckoDriverLog.isFile()) throw new Exception("Pfad zur GeckoDriver-Log scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                if (!rawGeckoDriverLog.canWrite()) throw new Exception("Pfad zur GeckoDriver-Log scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                if (!rawGeckoDriverLog.canRead()) {
                                    throw new Exception("Pfad zur GeckoDriver-Log scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                }
                            }
                            String firefoxDriverLogPath = rawGeckoDriverLog.getCanonicalPath();
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Angegebener Pfad zum Firefox Downloads-Verzeichnis: " + rawFirefoxDownloadsPath);
                            if (StringCharUtils.isNullOrEmptyOrNothing(rawFirefoxDownloadsPath)) {
                                if (StringCharUtils.isNullOrEmptyOrNothing(System.getProperty("firefox.downloads.path"))) throw new Exception("Pfad zur Firefox Downloads-Ordner ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"selenium.downloads.path\", <Pfad zum Downloads-Verzeichnis>);'");
                                rawFirefoxDownloadsPath = System.getProperty("firefox.downloads.path");
                            }
                            if ((rawFirefoxDownloadPath = new File(rawFirefoxDownloadsPath)).exists()) {
                                FileUtils.forceDelete((File)rawFirefoxDownloadPath);
                            }
                            if (!rawFirefoxDownloadPath.exists()) {
                                try {
                                    FileUtils.forceMkdir((File)rawFirefoxDownloadPath);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    LogError.invoke((Object)LogError, "[WebSync:GeckoDriverWebClientInit] Firefox Downloads-Ordner existierte nicht und konnte aber auch nicht angelegt werden! \\u00dcberpr\u00fcfen Sie die Pfadangabe; Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                if (!rawFirefoxDownloadPath.canWrite()) throw new Exception("Pfad zur Firefox Downloads-Ordner scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                if (!rawFirefoxDownloadPath.canRead()) {
                                    throw new Exception("Pfad zur Firefox Downloads-Ordner scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                }
                            }
                            String firefoxDownloadsPath = rawFirefoxDownloadPath.getCanonicalPath();
                            System.setProperty("webdriver.gecko.driver", firefoxDriverBinaryPath);
                            System.setProperty("selenium.LOGGER", firefoxDriverLogPath);
                            System.setProperty("selenium.LOGGER.level", "WARNING");
                            System.setProperty("webdriver.firefox.logfile", firefoxDriverLogPath);
                            System.setProperty("webdriver.firefox.verboseLogging", "true");
                            options = new FirefoxOptions();
                            FirefoxProfile profile = new FirefoxProfile();
                            options.setAcceptInsecureCerts(lowssl);
                            profile.setAcceptUntrustedCertificates(lowssl);
                            profile.setAssumeUntrustedCertificateIssuer(lowssl);
                            profile.setPreference("javascript.enabled", (Object)js);
                            profile.setPreference("security.fileuri.strict_origin_policy", (Object)websec);
                            profile.setPreference("security.mixed_content.block_active_content", (Object)websec);
                            profile.setPreference("browser.download.dir", (Object)firefoxDownloadsPath);
                            profile.setPreference("browser.download.folderList", (Object)2);
                            profile.setPreference("browser.helperApps.neverAsk.saveToDisk", (Object)"application/x-csv,text/plain,text/comma-separated-values,x-unkown,octet/stream,application/pdf,text/plain,application/octet-stream,application/x-pdf,application/vnd.pdf,application/vnd.openxmlformats-officedocument.spreadsheethtml,text/csv,text/html,application/x-msexcel,application/excel,application/x-excel,application/vnd.ms-excel");
                            profile.setPreference("browser.download.useDownloadDir", (Object)true);
                            profile.setPreference("browser.helperApps.alwaysAsk.force", (Object)false);
                            profile.setPreference("browser.download.manager.useWindow", (Object)false);
                            profile.setPreference("browser.download.manager.focusWhenStarting", (Object)false);
                            profile.setPreference("browser.download.manager.alertOnEXEOpen", (Object)false);
                            profile.setPreference("browser.download.manager.showAlertOnComplete", (Object)false);
                            profile.setPreference("browser.download.manager.closeWhenDone", (Object)false);
                            profile.setPreference("browser.allowpopups", (Object)false);
                            profile.setPreference("pdfjs.disabled", (Object)true);
                            profile.setPreference("intl.accept_languages", (Object)"de");
                            options.setProfile(profile);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] es wird auf eine Proxy-Konfiguration gepr\u00fcft ...");
                            proxy = new Proxy();
                            if (!appSysProxyUse && (appProxyHost == null || appProxyPort == -1 || appSysProxyUse) && (appHttpsProxyHost == null || appHttpsProxyPort == -1 || appSysProxyUse)) break block83;
                            LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] GeckoDriver Proxy-Einstellungen setzen ...");
                            MonitorLog.invoke((Object)MonitorLog, "GeckoDriver Proxy-Einstellungen setzen ...");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Die Applikation nutzt den System-Proxy: " + appSysProxyUse);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTP-Proxy Host von der Applikation ist: " + appProxyHost);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTP-Proxy Port von der Applikation ist: " + appProxyPort);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTPS-Proxy Host von der Applikation ist: " + appHttpsProxyHost);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTPS-Proxy Port von der Applikation ist: " + appHttpsProxyPort);
                            if (!appSysProxyUse) break block84;
                            System.setProperty("java.net.useSystemProxies", "true");
                            sysProxyInfoHTTP = ProxySelector.getDefault().select(new URI("http://www.java.de")).get(0).toString();
                            sysProxyInfoHTTPS = ProxySelector.getDefault().select(new URI("https://www.mydrive.ch")).get(0).toString();
                            sysProxyFehler = 0;
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTP Proxy-Einstellung des Systems ist f\u00fcr Java: " + sysProxyInfoHTTP);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTPS Proxy-Einstellung des Systems ist f\u00fcr Java: " + sysProxyInfoHTTPS);
                            if (sysProxyInfoHTTP != "DIRECT" || sysProxyInfoHTTPS != "DIRECT") break block85;
                            MonitorLog.invoke((Object)MonitorLog, "Info-Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy im System eingetragen!");
                            LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy im System eingetragen!");
                            proxy.setProxyType(Proxy.ProxyType.DIRECT);
                            break block82;
                        }
                        String sysProxyHost = null;
                        int sysProxyPort = 0;
                        if (sysProxyInfoHTTP != "DIRECT") {
                            String[] sysProxyValuesString = sysProxyInfoHTTP.split(" @ ");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] SysProxyValuesString: " + sysProxyValuesString);
                            String sysProxyProtokol = sysProxyValuesString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] SysProxyProtokol: " + sysProxyProtokol);
                            String SysProxySetting = sysProxyValuesString[1];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] SysProxySetting: " + SysProxySetting);
                            String[] sysProxyString = SysProxySetting.split(":");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] SysProxyString: " + sysProxyString);
                            sysProxyHost = sysProxyString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTP-Proxy Host des Systems ist f\u00fcr Java: " + sysProxyHost);
                            sysProxyPort = Integer.parseInt(sysProxyString[1]);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTP-Proxy Port des Systems ist f\u00fcr Java: " + sysProxyPort);
                        } else {
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTP im System eingetragen!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTP im System eingetragen!");
                            ++sysProxyFehler;
                        }
                        String sysHttpsProxyHost = null;
                        int sysHttpsProxyPort = 0;
                        if (sysProxyInfoHTTPS != "DIRECT") {
                            String[] SysHttpsProxyValuesString = sysProxyInfoHTTPS.split(" @ ");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] SysHttpsProxyValuesString: " + SysHttpsProxyValuesString);
                            String SysHttpsProxyProtokol = SysHttpsProxyValuesString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] SysHttpsProxyProtokol: " + SysHttpsProxyProtokol);
                            String SysHttpsProxySetting = SysHttpsProxyValuesString[1];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] SysHttpsProxySetting: " + SysHttpsProxySetting);
                            String[] SysHttpsProxyString = SysHttpsProxySetting.split(":");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] SysHttpsProxyString: " + SysHttpsProxyString);
                            sysHttpsProxyHost = SysHttpsProxyString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTPS-Proxy Host des Systems ist f\u00fcr Java: " + sysHttpsProxyHost);
                            sysHttpsProxyPort = Integer.parseInt(SysHttpsProxyString[1]);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] HTTPS-Proxy Port des Systems ist f\u00fcr Java: " + sysHttpsProxyPort);
                        } else {
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTPS im System eingetragen!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTPS im System eingetragen!");
                            ++sysProxyFehler;
                        }
                        if (sysHttpsProxyHost != null && sysHttpsProxyPort != -1) {
                            proxy.setProxyType(Proxy.ProxyType.SYSTEM);
                            MonitorLog.invoke((Object)MonitorLog, "OK: Es wird der HTTPS-Proxy vom System benutzt");
                            LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] Es wird der HTTPS-Proxy vom System benutzt");
                            break block82;
                        } else if (sysProxyHost != null && sysProxyPort != -1) {
                            proxy.setProxyType(Proxy.ProxyType.SYSTEM);
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Es wird der HTTP-Proxy vom System benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Es wird der HTTP-Proxy vom System benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                            break block82;
                        } else {
                            if (++sysProxyFehler != 3) throw new Exception("Systemproxy-Einstellungen verwenden ist gew\u00e4hlt: aber bei diesen fehlt offensichtlich ein Eintrag!");
                            MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: Es sieht so aus als w\u00fcrden Sie eigentlich keinen Proxy verwenden ...");
                            MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: ... entfernen Sie daher wom\u00f6glich einfach den Hacken der Proxykonfiguration ...");
                            MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: ... 'System-Einstellungen verwenden' in den Programm-Einstellungen, um diesen Fehler zu beheben");
                            throw new Exception("Systemproxy-Einstellungen verwenden ist gew\u00e4hlt: aber bei diesen fehlt offensichtlich ein Eintrag!");
                        }
                    }
                    if (appHttpsProxyHost != null && appHttpsProxyPort != -1 && !appSysProxyUse) {
                        proxy.setProxyType(Proxy.ProxyType.MANUAL);
                        proxy.setHttpProxy(appHttpsProxyHost + ":" + appHttpsProxyPort);
                        proxy.setSslProxy(appHttpsProxyHost + ":" + appHttpsProxyPort);
                        MonitorLog.invoke((Object)MonitorLog, "OK: Es wird der HTTPS-Proxy von der Applikation benutzt");
                        LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] Es wird der HTTPS-Proxy von der Applikation benutzt");
                        break block82;
                    } else if (appProxyHost != null && appProxyPort != -1 && !appSysProxyUse) {
                        proxy.setProxyType(Proxy.ProxyType.MANUAL);
                        proxy.setHttpProxy(appProxyHost + ":" + appProxyHost);
                        proxy.setSslProxy(appProxyHost + ":" + appProxyHost);
                        MonitorLog.invoke((Object)MonitorLog, "Warnung: Es wird der HTTP-Proxy von der Applikation benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                        LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Es wird der HTTP-Proxy von der Applikation benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                    }
                    break block82;
                }
                if (appProxyHost != null && appProxyPort == -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTP-Proxy eingetragen aber die Port-Einstellung fehlt!");
                }
                if (appProxyHost == null && appProxyPort != -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTP-Proxy-Port eingetragen aber die Host-Einstellung fehlt!");
                }
                if (appHttpsProxyHost != null && appHttpsProxyPort == -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTPS-Proxy eingetragen aber die Port-Einstellung fehlt!");
                }
                if (appHttpsProxyHost == null && appHttpsProxyPort != -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTPS-Proxy-Port eingetragen aber die Host-Einstellung fehlt!");
                }
                proxy.setProxyType(Proxy.ProxyType.DIRECT);
                LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] ... es ist auf keine aktive Weise ein Proxy eingestellt");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Erzeugtes Proxy-Objekt::: Type: " + proxy.getProxyType() + " ::: HTTP: " + proxy.getHttpProxy() + " ::: HTTPS: " + proxy.getSslProxy() + " ::: noProxy: " + proxy.getNoProxy());
            options.setProxy(proxy);
            ArrayList<String> comlineArgs = new ArrayList<String>();
            comlineArgs.add("--disable-geolocation");
            comlineArgs.add("--disable-notifications");
            comlineArgs.add("--disable-gpu");
            comlineArgs.add("--disable-infobars");
            comlineArgs.add("--disable-password-generation");
            comlineArgs.add("--disable-sync");
            if (headlessMode) {
                options.addArguments(new String[]{"-headless"});
            }
            options.addArguments(new String[]{"--window-size=1920,1080"});
            options.addArguments(new String[]{"--width=1920"});
            options.addArguments(new String[]{"--height=1080"});
            comlineArgs.add("--start-maximized");
            if (!websec) {
                comlineArgs.add("--disable-web-security");
            }
            comlineArgs.add("--dns-prefetch-disable");
            comlineArgs.add("--no-sandbox");
            options.addArguments(comlineArgs);
            if (StringCharUtils.isNullOrEmptyOrNothing(rawFirefoxRootPath)) {
                throw new Exception("Ablage-Pfad zu alternativem Firefox ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"firefox.root.path\", <Ablagepfad>);'");
            }
            File extractRootPath = new File(rawFirefoxRootPath);
            if (extractRootPath.exists() && extractRootPath.list().length < 1) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Lerres Verzeichnis des alternativen Firefox wird entfernt ...");
                FileUtils.forceDelete((File)extractRootPath);
            }
            boolean ownFirefoxIsUsed = false;
            boolean freshFirefox = false;
            try {
                if (forceUseAlterateBrowser) {
                    ownFirefoxIsUsed = true;
                    LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] Nutzung des alternativen Firefox-Browser wurde erzwungen. (Property(\"selenium.forceuse.alternatebrowser\") = true)");
                    MonitorLog.invoke((Object)MonitorLog, "Nutzung des alternativen Firefox-Browser wurde erzwungen. (Property(\"selenium.forceuse.alternatebrowser\") = true)");
                    if (!new File(rawFirefoxBinaryPath).exists()) {
                        throw new WebDriverException("Cannot find firefox binary in PATH");
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Setze Pfad zur alternativen Firefox-Binary: " + rawFirefoxBinaryPath);
                    options.setBinary(rawFirefoxBinaryPath);
                    ownFirefoxIsUsed = true;
                    try {
                        GeckoDriverUtils.secuityCheckOfBrowser(ExternalLogger, ExternalProgressMonitor);
                    }
                    catch (Exception checkerror) {
                        isSelfException = true;
                        throw new Exception(checkerror.getMessage());
                    }
                }
                driver = new FirefoxDriver(options);
            }
            catch (WebDriverException driverException) {
                String shortException = driverException.getMessage().split("\r\n|\r|\n|" + System.lineSeparator(), 2)[0];
                LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Erst-Initialisierung von Firefox fehlgeschlagen, reagiere auf Exception:  " + shortException);
                if (!(shortException.contains("Cannot find firefox binary in PATH") || shortException.contains("firefox not reachable") || shortException.contains("Firefox version must be ") || shortException.contains("Process unexpectedly closed ") || shortException.contains("connection refused") || StringCharUtils.isNullOrEmptyOrNothing(shortException))) {
                    if (!extractRootPath.exists()) throw new Exception(driverException);
                    if (forceUseAlterateBrowser) throw new Exception(driverException);
                    LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] Hinweis: Firefox gefunden. Alternativer Firefox wird daher nun wieder entfernt ...");
                    MonitorLog.invoke((Object)MonitorLog, "Hinweis: Firefox gefunden. Alternativer Firefox wird daher nun wieder entfernt ...");
                    FileUtils.forceDelete((File)extractRootPath);
                    throw new Exception(driverException);
                }
                try {
                    if (!extractRootPath.exists() || shortException.contains("Firefox version must be ")) {
                        String errorMsg = shortException.trim();
                        LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] errorMsg: " + errorMsg);
                        if (!extractRootPath.exists() && (shortException.contains("Firefox version must be ") || shortException.contains("Process unexpectedly closed ") || shortException.contains("connection refused") || StringCharUtils.isNullOrEmptyOrNothing(shortException))) {
                            LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Firefox liegt in einer nicht kompatiblen Version vor (Fehler: " + errorMsg + "). Dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt wenn Firefox in einer kompatiblen Version gefunden wird!)");
                            MonitorLog.invoke((Object)MonitorLog, "Hinweis: Firefox liegt in einer nicht kompatiblen Version vor (Fehler: " + errorMsg + ") ...");
                            MonitorLog.invoke((Object)MonitorLog, "... dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Firefox in einer kompatiblen Version gefunden wird!)");
                            try {
                                GeckoDriverUtils.getFirefoxBrowser(ExternalLogger, ExternalProgressMonitor);
                            }
                            catch (Exception geckoutilserr) {
                                throw new Exception(geckoutilserr.getMessage());
                            }
                            freshFirefox = true;
                        } else if (extractRootPath.exists() && (shortException.contains("Firefox version must be ") || shortException.contains("Process unexpectedly closed ") || shortException.contains("connection refused") || StringCharUtils.isNullOrEmptyOrNothing(shortException))) {
                            LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Firefox liegt in einer nicht kompatiblen Version vor (Fehler: " + errorMsg + "). Daher wird nun der automatisch nachgeladene Firefox verwendet ... (dieser wird wieder entfernt, wenn Firefox in einer kompatiblen Version gefunden wird!)");
                            MonitorLog.invoke((Object)MonitorLog, "Hinweis: Firefox liegt in einer nicht kompatiblen Version vor (Fehler: " + errorMsg + ") ...");
                            MonitorLog.invoke((Object)MonitorLog, "... daher wird nun der automatisch nachgeladene Firefox verwendet ... (dieser wird wieder entfernt wenn Firefox in einer kompatiblen Version gefunden wird!)");
                        } else {
                            LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Firefox konnte nicht gefunden werden. Dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Firefox gefunden wird!)");
                            MonitorLog.invoke((Object)MonitorLog, "Hinweis: Firefox konnte nicht gefunden werden ...");
                            MonitorLog.invoke((Object)MonitorLog, "... dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Firefox gefunden wird!)");
                            try {
                                GeckoDriverUtils.getFirefoxBrowser(ExternalLogger, ExternalProgressMonitor);
                            }
                            catch (Exception geckoutilserr) {
                                throw new Exception(geckoutilserr.getMessage());
                            }
                            freshFirefox = true;
                        }
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Setze Pfad zur alternativen Firefox-Binary: " + rawFirefoxBinaryPath);
                    options.setBinary(rawFirefoxBinaryPath);
                    ownFirefoxIsUsed = true;
                    try {
                        GeckoDriverUtils.secuityCheckOfBrowser(ExternalLogger, ExternalProgressMonitor);
                    }
                    catch (Exception checkerror) {
                        isSelfException = true;
                        throw new Exception(checkerror.getMessage());
                    }
                    try {
                        driver = new FirefoxDriver(options);
                    }
                    catch (Exception ownFirefoxDriverException) {
                        String shortExceptionOwnFirefox = ownFirefoxDriverException.getMessage().split("\r\n|\r|\n|" + System.lineSeparator(), 2)[0];
                        LogDebug.invoke((Object)LogDebug, "[WebSync:GeckoDriverWebClientInit] Initialisierung des alternativen Firefox fehlgeschlagen, reagiere auf Exception:  " + shortExceptionOwnFirefox);
                        if (extractRootPath.exists() && shortExceptionOwnFirefox.contains("Firefox version must be ") || shortExceptionOwnFirefox.contains("Process unexpectedly closed ") || shortExceptionOwnFirefox.contains("connection refused") || StringCharUtils.isNullOrEmptyOrNothing(shortExceptionOwnFirefox)) {
                            LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Alternativer Firefox liegt in einer nicht kompatiblen Version vor (Fehler: " + shortExceptionOwnFirefox + "). Dieser wird daher nun automatisch aktualisiert ... (und wird wieder entfernt, wenn Firefox in einer kompatiblen Version gefunden wird!)");
                            MonitorLog.invoke((Object)MonitorLog, "Hinweis: Alternativer Firefox liegt in einer nicht kompatiblen Version vor (Fehler: " + shortExceptionOwnFirefox + ") ...");
                            MonitorLog.invoke((Object)MonitorLog, "... dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Firefox in einer kompatiblen Version gefunden wird!)");
                            try {
                                GeckoDriverUtils.getFirefoxBrowser(ExternalLogger, ExternalProgressMonitor);
                            }
                            catch (Exception geckoutilserr) {
                                throw new Exception(geckoutilserr.getMessage());
                            }
                            freshFirefox = true;
                        } else if (!extractRootPath.exists()) {
                            LogWarn.invoke((Object)LogWarn, "[WebSync:GeckoDriverWebClientInit] Alternativer Firefox konnte nicht gefunden werden. Dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Firefox gefunden wird!)");
                            MonitorLog.invoke((Object)MonitorLog, "Hinweis: Alternativer Firefox konnte nicht gefunden werden ...");
                            MonitorLog.invoke((Object)MonitorLog, "... dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Firefox gefunden wird!)");
                            try {
                                GeckoDriverUtils.getFirefoxBrowser(ExternalLogger, ExternalProgressMonitor);
                            }
                            catch (Exception geckoutilserr) {
                                throw new Exception(geckoutilserr.getMessage());
                            }
                            freshFirefox = true;
                        }
                        freshFirefox = true;
                        driver = new FirefoxDriver(options);
                    }
                }
                catch (Exception loaderror) {
                    isSelfException = true;
                    throw new Exception("Lades des alternativen Firefox fehlgeschlagen! " + ExceptionUtils.getStackTrace((Throwable)loaderror));
                }
            }
            try {
                if (!freshFirefox) {
                    FirefoxVersion.checkAndSet((RemoteWebDriver)driver, ExternalLogger, ExternalProgressMonitor);
                }
            }
            catch (Exception versionErr) {
                SeleniumUtils.quitBrowserDriver(driver, ExternalLogger);
                if (!versionErr.getMessage().equals("newDownloadHaveToReinitialize")) {
                    isSelfException = true;
                    throw new Exception(versionErr.getMessage());
                }
                options.setBinary(rawFirefoxBinaryPath);
                ownFirefoxIsUsed = true;
                try {
                    GeckoDriverUtils.secuityCheckOfBrowser(ExternalLogger, ExternalProgressMonitor);
                }
                catch (Exception checkerror) {
                    isSelfException = true;
                    throw new Exception(checkerror.getMessage());
                }
                driver = new FirefoxDriver(options);
            }
            if (extractRootPath.exists() && !ownFirefoxIsUsed) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] Hinweis: Firefox gefunden. Alternativer Firefox wird daher nun wieder entfernt ...");
                MonitorLog.invoke((Object)MonitorLog, "Hinweis: Firefox gefunden. Alternativer Firefox wird daher nun wieder entfernt ...");
                FileUtils.forceDelete((File)extractRootPath);
            }
            TimeUnit.SECONDS.sleep(1L);
            driver.manage().timeouts().scriptTimeout(Duration.ofSeconds(2L));
            driver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(90L));
            driver.manage().window().setSize(new Dimension(1920, 1080));
            driver.manage().window().maximize();
            LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] Session-ID: " + ((RemoteWebDriver)driver).getSessionId());
            LogInfo.invoke((Object)LogInfo, "[WebSync:GeckoDriverWebClientInit] GeckoDriver-Webclient wurde erfolgreich vorbereitet");
            return driver;
        }
        catch (Exception error) {
            SeleniumUtils.quitBrowserDriver(driver, ExternalLogger);
            if (!isSelfException) throw new Exception("Erstellen des WebClient fehlgeschlagen!\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception(error.getMessage());
        }
    }

    static {
        rawGeckoDriverBinaryPath = System.getProperty("webdriver.gecko.driver");
        rawGeckoDriverLogPath = System.getProperty("geckodriver.logfile.path");
        rawFirefoxRootPath = System.getProperty("firefox.root.path");
        rawFirefoxBinaryPath = System.getProperty("firefox.binary.path");
        rawFirefoxDownloadsPath = System.getProperty("selenium.downloads.path");
        forceUseAlterateBrowser = Boolean.parseBoolean(System.getProperty("selenium.forceuse.alternatebrowser"));
    }
}

