/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.connector;

import de.derrichter.finance.websync.Version;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.check.ChromiumVersion;
import de.derrichter.finance.websync.utils.webdrivertools.ChromeDriverUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.RemoteWebDriver;

public class ChromeDriverWebClientInit {
    private static final String logIdent = "[WebSync:ChromeDriverWebClientInit] ";
    private static WebDriver driver;
    private static String rawChromeDriverBinaryPath;
    private static final String rawChromeDriverLogPath;
    private static final String rawChromiumRootPath;
    private static String rawChromiumBinaryPath;
    private static String rawChromeDownloadsPath;
    private static final boolean forceUseAlterateBrowser;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WebDriver connConfig(boolean lowssl, boolean js, boolean websec, Class<?> externalLogger, Class<?> externalProgressMonitor, boolean appSysProxyUse, String appProxyHost, int appProxyPort, String appHttpsProxyHost, int appHttpsProxyPort, boolean appProxyAuthUse, String ProxyUser, String ProxyPass, boolean headlessMode, String profilePath, String loadExtention) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        boolean isSelfException = false;
        String osname = System.getProperty("os.name").toLowerCase();
        String osarch = System.getProperty("os.arch");
        String osversion = System.getProperty("os.version");
        LogDebug.invoke((Object)LogDebug, "OS-Info: " + osname + " " + osarch);
        SeleniumUtils.quitBrowserDriver(driver, externalLogger);
        String javaversion = System.getProperty("java.version");
        if (javaversion.startsWith("1.")) {
            javaversion = javaversion.substring(2, 3);
        } else {
            int dot = javaversion.indexOf(".");
            if (dot != -1) {
                javaversion = javaversion.substring(0, dot);
            }
        }
        int javamainver = Integer.parseInt(javaversion);
        LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Java-Mainversion for HTTP-Client-Choose: " + String.valueOf(javamainver));
        try {
            File workDir;
            Proxy proxy;
            ChromeOptions options;
            block122: {
                block123: {
                    block124: {
                        int sysProxyFehler;
                        String sysProxyInfoHTTPS;
                        String sysProxyInfoHTTP;
                        block125: {
                            File rawChromeDownloadPath;
                            LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] ChromeDriver-Webclient wird vorbereitet ...");
                            if (javamainver >= 11) {
                                System.setProperty("webdriver.http.factory", "jdk-http-client");
                                LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] webdriver.http.factory: jdk-http-client");
                            } else {
                                System.setProperty("webdriver.http.factory", "netty");
                                LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] webdriver.http.factory: netty");
                            }
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Angegebener Pfad zur ChromeDriver-Binary: " + rawChromeDriverBinaryPath);
                            if (StringCharUtils.isNullOrEmptyOrNothing(rawChromeDriverBinaryPath)) {
                                throw new Exception("Pfad zur ChromeDriver-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"chromedriver.binary.path\", <Pfad zur Binary>);'");
                            }
                            File chromeDriverBinary = new File(rawChromeDriverBinaryPath);
                            if (!chromeDriverBinary.exists()) {
                                if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "macos" + File.separator + "chromedriver")) {
                                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("macos", "macos64");
                                } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "macos64" + File.separator + "chromedriver")) {
                                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("macos64", "macos");
                                } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "macos-arm" + File.separator + "chromedriver")) {
                                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("macos-arm", "macos-aarch64");
                                } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "macos-aarch64" + File.separator + "chromedriver")) {
                                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("macos-aarch64", "macos-arm");
                                } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "windows" + File.separator + "chromedriver.exe")) {
                                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("windows", "win32");
                                } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "win32" + File.separator + "chromedriver.exe")) {
                                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("win32", "windows");
                                } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "win64" + File.separator + "chromedriver.exe")) {
                                    File chromeDriverPath = new File(rawChromeDriverBinaryPath);
                                    if (!chromeDriverPath.exists()) {
                                        rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("win64", "win32");
                                    }
                                } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "linux-arm" + File.separator + "chromedriver")) {
                                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("linux-arm", "linux-aarch64");
                                } else if (rawChromeDriverBinaryPath.endsWith("hibiscus.scripting.chromedriver" + File.separator + "bin" + File.separator + "linux-aarch64" + File.separator + "chromedriver")) {
                                    rawChromeDriverBinaryPath = rawChromeDriverBinaryPath.replace("linux-aarch64", "linux-arm");
                                }
                                chromeDriverBinary = new File(rawChromeDriverBinaryPath);
                                if (!chromeDriverBinary.exists()) {
                                    isSelfException = true;
                                    throw new Exception("Pfad zur ChromeDriver-Binary scheint nicht korrekt. (Existiert nicht) Bitte \u00fcberpr\u00fcfen Sie diesen: " + rawChromeDriverBinaryPath);
                                }
                            }
                            if (!chromeDriverBinary.isFile()) {
                                isSelfException = true;
                                throw new Exception("Pfad zur ChromeDriver-Binary scheint nicht korrekt. (Keine Datei) Bitte \u00fcberpr\u00fcfen Sie diesen.");
                            }
                            try {
                                if (!chromeDriverBinary.canExecute()) {
                                    chromeDriverBinary.setExecutable(true);
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] ChromeDriver-Binary wurde erfolgreich als ausf\u00fcrbar markiert");
                                }
                            }
                            catch (Exception error1) {
                                isSelfException = true;
                                throw new Exception("ChromeDriver-Binary konnte nicht auf Ausf\u00fchrbarkeit gepr\u00fcft oder gesetzt werden: " + ExceptionUtils.getStackTrace((Throwable)error1));
                            }
                            String chromeDriverBinaryPath = chromeDriverBinary.getCanonicalPath();
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Angegebener Pfad zur ChromeDriver-Logdatei: " + rawChromeDriverLogPath);
                            if (StringCharUtils.isNullOrEmptyOrNothing(rawChromeDriverLogPath)) {
                                throw new Exception("Pfad zur ChromeDriver-Log ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"chromedriver.logfile.path\", <Pfad zum Logfile>);'");
                            }
                            File rawChromeDriverLog = new File(rawChromeDriverLogPath);
                            if (!rawChromeDriverLog.exists()) {
                                try {
                                    rawChromeDriverLog.createNewFile();
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    LogError.invoke((Object)LogError, "[WebSync:ChromeDriverWebClientInit] ChromeDriver-Logdatei existierte nicht und konnte aber auch nicht angelegt werden! \u00dcberpr\u00fcfen Sie die Pfadangabe; Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                if (!(rawChromeDriverLog.isFile() && rawChromeDriverLog.canWrite() && rawChromeDriverLog.canRead())) {
                                    throw new Exception("Pfad zur ChromeDriver-Log scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                }
                            }
                            String chromeDriverLogPath = rawChromeDriverLog.getCanonicalPath();
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Angegebener Pfad zum Chrome Downloads-Verzeichnis: " + rawChromeDownloadsPath);
                            if (StringCharUtils.isNullOrEmptyOrNothing(rawChromeDownloadsPath)) {
                                if (StringCharUtils.isNullOrEmptyOrNothing(System.getProperty("chrome.downloads.path"))) {
                                    throw new Exception("Pfad zur Chrome Downloads-Ordner ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"selenium.downloads.path\", <Pfad zum Downloads-Verzeichnis>);'");
                                }
                                rawChromeDownloadsPath = System.getProperty("chrome.downloads.path");
                            }
                            if ((rawChromeDownloadPath = new File(rawChromeDownloadsPath)).exists()) {
                                FileUtils.forceDelete((File)rawChromeDownloadPath);
                            }
                            if (!rawChromeDownloadPath.exists()) {
                                try {
                                    FileUtils.forceMkdir((File)rawChromeDownloadPath);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    LogError.invoke((Object)LogError, "[WebSync:ChromeDriverWebClientInit] Chrome Downloads-Ordner existierte nicht und konnte aber auch nicht angelegt werden! \u00dcberpr\u00fcfen Sie die Pfadangabe; Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                if (!rawChromeDownloadPath.canWrite() || !rawChromeDownloadPath.canRead()) {
                                    throw new Exception("Pfad zur Chrome Downloads-Ordner scheint nicht korrekt oder kann nicht geschrieben werden. Bitte \u00fcberpr\u00fcfen Sie diese.");
                                }
                            }
                            String chromeDownloadsPath = rawChromeDownloadPath.getCanonicalPath();
                            System.setProperty("webdriver.chrome.driver", chromeDriverBinaryPath);
                            System.setProperty("selenium.LOGGER", chromeDriverLogPath);
                            System.setProperty("selenium.LOGGER.level", "WARNING");
                            System.setProperty("webdriver.chrome.logfile", chromeDriverLogPath);
                            System.setProperty("webdriver.chrome.verboseLogging", "true");
                            if (!StringCharUtils.isNullOrEmptyOrNothing(loadExtention) && loadExtention.equals("ca\u00admou\u00adf\u00adla\u00adge-mode")) {
                                FileSysUtils.replaceKeyWithRadndomInBinary(chromeDriverBinaryPath, "cdc_", 22);
                            }
                            options = new ChromeOptions();
                            options.setAcceptInsecureCerts(lowssl);
                            LoggingPreferences logPrefs = new LoggingPreferences();
                            logPrefs.enable("performance", Level.ALL);
                            HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
                            chromePrefs.put("profile.default_content_settings.popups", 0);
                            chromePrefs.put("credentials_enable_service", "false");
                            chromePrefs.put("password_manager_enabled", "false");
                            chromePrefs.put("download.prompt_for_download", "false");
                            chromePrefs.put("download.directory_upgrade", "true");
                            chromePrefs.put("download.default_directory", chromeDownloadsPath);
                            if (!js) {
                                chromePrefs.put("webkit.webprefs.javascript_enabled", false);
                                chromePrefs.put("profile.content_settings.exceptions.javascript.*.setting", 2);
                                chromePrefs.put("profile.default_content_setting_values.javascript", 2);
                                chromePrefs.put("profile.managed_default_content_settings.javascript", 2);
                            }
                            if (!StringCharUtils.isNullOrEmptyOrNothing(loadExtention) && loadExtention.equals("ca\u00admou\u00adf\u00adla\u00adge-mode")) {
                                chromePrefs.put("useAutomationExtension", false);
                                options.setExperimentalOption("useAutomationExtension", (Object)false);
                                chromePrefs.put("excludeSwitches", Collections.singletonList("enable-automation"));
                                options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
                            } else {
                                chromePrefs.put("plugins.plugins_disabled", new String[]{"Chrome PDF Viewer"});
                                chromePrefs.put("plugins.always_open_pdf_externally", true);
                            }
                            chromePrefs.put("intl.accept_languages", "de-DE,de,en-US,en");
                            chromePrefs.put("credentials_enable_service", false);
                            chromePrefs.put("profile.password_manager_enabled", false);
                            options.setExperimentalOption("prefs", chromePrefs);
                            options.setCapability("goog:loggingPrefs", (Object)logPrefs);
                            options.setCapability("goog:loggingPrefs", (Object)logPrefs);
                            options.setCapability("goog:chromeOptions", chromePrefs);
                            options.setPageLoadStrategy(PageLoadStrategy.NONE);
                            if (!StringCharUtils.isNullOrEmptyOrNothing(loadExtention)) {
                                File workDir2 = new File(Version.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                                String workingDir = workDir2.getAbsolutePath().replace("finance.websync.jar", "").trim();
                                LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] workingDir: " + workingDir);
                                String[] decodedPath = new String[]{loadExtention.equals("ca\u00admou\u00adf\u00adla\u00adge-mode") ? URLDecoder.decode(new String(workingDir + File.separator + "resources" + File.separator + "extensions" + File.separator + "buster-rapi2.crx").trim(), "UTF-8") : (!loadExtention.contains(File.separator) ? URLDecoder.decode(workingDir + File.separator + "resources" + File.separator + "extensions" + File.separator + loadExtention, "UTF-8") : URLDecoder.decode(loadExtention, "UTF-8"))};
                                for (String path : decodedPath) {
                                    File extension = new File(path);
                                    LogDebug.invoke((Object)LogDebug, logIdent + path + " exits (default: true): " + extension.exists());
                                    LogDebug.invoke((Object)LogDebug, logIdent + path + " is absolute path (default: true): " + extension.isAbsolute());
                                    LogDebug.invoke((Object)LogDebug, logIdent + path + " is a directory (default: false): " + extension.isDirectory());
                                    LogDebug.invoke((Object)LogDebug, logIdent + path + " is a file (default: true): " + extension.isFile());
                                    LogDebug.invoke((Object)LogDebug, logIdent + path + " can execute (default: false): " + extension.canExecute());
                                    options.addExtensions(new File[]{new File(path)});
                                }
                            }
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] es wird auf eine Proxy-Konfiguration gepr\u00fcft ...");
                            proxy = new Proxy();
                            if (!appSysProxyUse && (appProxyHost == null || appProxyPort == -1 || appSysProxyUse) && (appHttpsProxyHost == null || appHttpsProxyPort == -1 || appSysProxyUse)) break block123;
                            LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] ChromeDriver Proxy-Einstellungen setzen ...");
                            MonitorLog.invoke((Object)MonitorLog, "ChromeDriver Proxy-Einstellungen setzen ...");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Die Applikation nutzt den System-Proxy: " + appSysProxyUse);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTP-Proxy Host von der Applikation ist: " + appProxyHost);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTP-Proxy Port von der Applikation ist: " + appProxyPort);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTPS-Proxy Host von der Applikation ist: " + appHttpsProxyHost);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTPS-Proxy Port von der Applikation ist: " + appHttpsProxyPort);
                            if (!appSysProxyUse) break block124;
                            System.setProperty("java.net.useSystemProxies", "true");
                            sysProxyInfoHTTP = ProxySelector.getDefault().select(new URI("http://www.java.de")).get(0).toString();
                            sysProxyInfoHTTPS = ProxySelector.getDefault().select(new URI("https://www.mydrive.ch")).get(0).toString();
                            sysProxyFehler = 0;
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTP Proxy-Einstellung des Systems ist f\u00fcr Java: " + sysProxyInfoHTTP);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTPS Proxy-Einstellung des Systems ist f\u00fcr Java: " + sysProxyInfoHTTPS);
                            if (sysProxyInfoHTTP != "DIRECT" || sysProxyInfoHTTPS != "DIRECT") break block125;
                            MonitorLog.invoke((Object)MonitorLog, "Info-Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy im System eingetragen!");
                            LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy im System eingetragen!");
                            proxy.setProxyType(Proxy.ProxyType.DIRECT);
                            break block122;
                        }
                        String sysProxyHost = null;
                        int sysProxyPort = 0;
                        if (sysProxyInfoHTTP != "DIRECT") {
                            String[] sysProxyValuesString = sysProxyInfoHTTP.split(" @ ");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] SysProxyValuesString: " + sysProxyValuesString);
                            String sysProxyProtokol = sysProxyValuesString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] SysProxyProtokol: " + sysProxyProtokol);
                            String SysProxySetting = sysProxyValuesString[1];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] SysProxySetting: " + SysProxySetting);
                            String[] sysProxyString = SysProxySetting.split(":");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] SysProxyString: " + sysProxyString);
                            sysProxyHost = sysProxyString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTP-Proxy Host des Systems ist f\u00fcr Java: " + sysProxyHost);
                            sysProxyPort = Integer.parseInt(sysProxyString[1]);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTP-Proxy Port des Systems ist f\u00fcr Java: " + sysProxyPort);
                        } else {
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTP im System eingetragen!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTP im System eingetragen!");
                            ++sysProxyFehler;
                        }
                        String sysHttpsProxyHost = null;
                        int sysHttpsProxyPort = 0;
                        if (sysProxyInfoHTTPS != "DIRECT") {
                            String[] sysHttpsProxyValuesString = sysProxyInfoHTTPS.split(" @ ");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] sysHttpsProxyValuesString: " + sysHttpsProxyValuesString);
                            String sysHttpsProxyProtokol = sysHttpsProxyValuesString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] sysHttpsProxyProtokol: " + sysHttpsProxyProtokol);
                            String sysHttpsProxySetting = sysHttpsProxyValuesString[1];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] sysHttpsProxySetting: " + (String)sysHttpsProxySetting);
                            String[] sysHttpsProxyString = sysHttpsProxySetting.split(":");
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] sysHttpsProxyString: " + sysHttpsProxyString);
                            sysHttpsProxyHost = sysHttpsProxyString[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTPS-Proxy Host des Systems ist f\u00fcr Java: " + sysHttpsProxyHost);
                            sysHttpsProxyPort = Integer.parseInt(sysHttpsProxyString[1]);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HTTPS-Proxy Port des Systems ist f\u00fcr Java: " + sysHttpsProxyPort);
                        } else {
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTPS im System eingetragen!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Systemproxy-Einstellungen verwenden ist in der Applikation eingestellt, es ist aber kein Proxy f\u00fcr HTTPS im System eingetragen!");
                            ++sysProxyFehler;
                        }
                        if (sysHttpsProxyHost != null && sysHttpsProxyPort != -1) {
                            proxy.setProxyType(Proxy.ProxyType.SYSTEM);
                            MonitorLog.invoke((Object)MonitorLog, "OK: Es wird der HTTPS-Proxy vom System benutzt");
                            LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] Es wird der HTTPS-Proxy vom System benutzt");
                            break block122;
                        } else if (sysProxyHost != null && sysProxyPort != -1) {
                            proxy.setProxyType(Proxy.ProxyType.SYSTEM);
                            MonitorLog.invoke((Object)MonitorLog, "Warnung: Es wird der HTTP-Proxy vom System benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                            LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Es wird der HTTP-Proxy vom System benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                            break block122;
                        } else {
                            if (++sysProxyFehler == 3) {
                                MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: Es sieht so aus als w\u00fcrden Sie eigentlich keinen Proxy verwenden ...");
                                MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: ... entfernen Sie daher wom\u00f6glich einfach den Hacken der Proxykonfiguration ...");
                                MonitorLog.invoke((Object)MonitorLog, "Warnungs-INFO: ... 'System-Einstellungen verwenden' in den Programm-Einstellungen, um diesen Fehler zu beheben");
                            }
                            throw new Exception("Systemproxy-Einstellungen verwenden ist gew\u00e4hlt: aber bei diesen fehlt offensichtlich ein Eintrag!");
                        }
                    }
                    if (appHttpsProxyHost != null && appHttpsProxyPort != -1 && !appSysProxyUse) {
                        proxy.setProxyType(Proxy.ProxyType.MANUAL);
                        proxy.setHttpProxy(appHttpsProxyHost + ":" + appHttpsProxyPort);
                        proxy.setSslProxy(appHttpsProxyHost + ":" + appHttpsProxyPort);
                        MonitorLog.invoke((Object)MonitorLog, "OK: Es wird der HTTPS-Proxy von der Applikation benutzt");
                        LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] Es wird der HTTPS-Proxy von der Applikation benutzt");
                        break block122;
                    } else if (appProxyHost != null && appProxyPort != -1 && !appSysProxyUse) {
                        proxy.setProxyType(Proxy.ProxyType.MANUAL);
                        proxy.setHttpProxy(appProxyHost + ":" + appProxyHost);
                        proxy.setSslProxy(appProxyHost + ":" + appProxyHost);
                        MonitorLog.invoke((Object)MonitorLog, "Warnung: Es wird der HTTP-Proxy von der Applikation benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                        LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Es wird der HTTP-Proxy von der Applikation benutzt. Sollte dieser kein HTTPS unterst\u00fczen gibt es Fehler!");
                    }
                    break block122;
                }
                if (appProxyHost != null && appProxyPort == -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTP-Proxy eingetragen aber die Port-Einstellung fehlt!");
                }
                if (appProxyHost == null && appProxyPort != -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTP-Proxy-Port eingetragen aber die Host-Einstellung fehlt!");
                }
                if (appHttpsProxyHost != null && appHttpsProxyPort == -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTPS-Proxy eingetragen aber die Port-Einstellung fehlt!");
                }
                if (appHttpsProxyHost == null && appHttpsProxyPort != -1 && !appSysProxyUse) {
                    throw new Exception("Es ist ein HTTPS-Proxy-Port eingetragen aber die Host-Einstellung fehlt!");
                }
                proxy.setProxyType(Proxy.ProxyType.DIRECT);
                LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] ... es ist auf keine aktive Weise ein Proxy eingestellt");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Erzeugtes Proxy-Objekt::: Type: " + proxy.getProxyType() + " ::: HTTP: " + proxy.getHttpProxy() + " ::: HTTPS: " + proxy.getSslProxy() + " ::: noProxy: " + proxy.getNoProxy());
            options.setProxy(proxy);
            ArrayList<String> comlineArgs = new ArrayList<String>();
            comlineArgs.add("--lang=de-DE");
            comlineArgs.add("--disable-geolocation");
            comlineArgs.add("--disable-password-generation");
            comlineArgs.add("--no-default-browser-check");
            comlineArgs.add("--no-first-run");
            comlineArgs.add("--disable-search-engine-choice-screen");
            comlineArgs.add("--deny-permission-prompts");
            if (!StringCharUtils.isNullOrEmptyOrNothing(loadExtention) && loadExtention.equals("ca\u00admou\u00adf\u00adla\u00adge-mode")) {
                comlineArgs.add("--disable-blink-features");
                comlineArgs.add("--disable-blink-features=AutomationControlled");
            } else {
                comlineArgs.add("--disable-notifications");
                comlineArgs.add("--disable-extensions");
            }
            comlineArgs.add("--disable-browser-side-navigation");
            comlineArgs.add("--disable-sync");
            comlineArgs.add("--enable-features=NetworkServiceInProcess");
            comlineArgs.add("--disable-features=NetworkService");
            comlineArgs.add("--check-for-update-interval=0");
            comlineArgs.add("--disable-component-update");
            comlineArgs.add("--extensions-update-frequency=0");
            comlineArgs.add("--window-size=1900,1000");
            comlineArgs.add("--start-maximized");
            if (headlessMode) {
                comlineArgs.add("--headless=new");
            }
            if (!websec) {
                comlineArgs.add("--disable-web-security");
            }
            comlineArgs.add("--dns-prefetch-disable");
            comlineArgs.add("--no-sandbox");
            comlineArgs.add("--disable-setuid-sandbox");
            comlineArgs.add("--disable-dev-shm-usage");
            if (javamainver < 11) {
                comlineArgs.add("--remote-allow-origins=*");
            }
            if (!StringCharUtils.isNullOrEmptyOrNothing(profilePath)) {
                workDir = new File(System.getProperty("user.home"));
                String homeDir = workDir.getAbsolutePath();
                LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HomeDir: " + homeDir);
                String decodedPath = "";
                decodedPath = !profilePath.contains(File.separator) ? URLDecoder.decode(homeDir + File.separator + ".mashup-browserprofiles" + File.separator + profilePath, "UTF-8") : URLDecoder.decode(profilePath, "UTF-8");
                comlineArgs.add("--user-data-dir=" + decodedPath);
            }
            workDir = new File(System.getProperty("user.home"));
            String homeDir = workDir.getAbsolutePath();
            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] HomeDir: " + homeDir);
            String decodedPath = URLDecoder.decode(homeDir + File.separator + ".mashup-browserprofiles", "UTF-8");
            FileSysUtils.forceDeleteTarget(new File(decodedPath));
            options.addArguments(comlineArgs);
            if (StringCharUtils.isNullOrEmptyOrNothing(rawChromiumRootPath)) {
                throw new Exception("Ablage-Pfad zu alternativem Chromium ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"chromium.root.path\", <Ablagepfad>);'");
            }
            File extractRootPath = new File(rawChromiumRootPath);
            if (extractRootPath.exists() && extractRootPath.list().length < 1) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Leeres Verzeichnis des alternativen Chromium wird entfernt ...");
                FileSysUtils.forceDeleteTarget(extractRootPath);
            }
            boolean alternativeChromiumBrowserIsUsed = false;
            boolean freshChrome = false;
            try {
                if (forceUseAlterateBrowser) {
                    alternativeChromiumBrowserIsUsed = true;
                    LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] Nutzung des alternativen Chromium-Browser wurde erzwungen. (Property(\"selenium.forceuse.alternatebrowser\") = true)");
                    MonitorLog.invoke((Object)MonitorLog, "Nutzung des alternativen Chromium-Browser wurde erzwungen. (Property(\"selenium.forceuse.alternatebrowser\") = true)");
                    File chromiumBinary = new File(rawChromiumBinaryPath);
                    if (!chromiumBinary.exists() || !chromiumBinary.isFile()) {
                        try {
                            ChromeDriverUtils.getChromiumBrowser(externalLogger, externalProgressMonitor);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error);
                        }
                        freshChrome = true;
                    }
                    try {
                        ChromeDriverWebClientInit.checkChromiumBinary(externalLogger);
                    }
                    catch (Exception checkererror) {
                        isSelfException = true;
                        throw new Exception(checkererror.getMessage());
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Setze Pfad zur alternativen Chromium-Binary: " + rawChromiumBinaryPath);
                    options.setBinary(rawChromiumBinaryPath);
                    alternativeChromiumBrowserIsUsed = true;
                    try {
                        ChromeDriverUtils.secuityCheckOfBrowser(externalLogger, externalProgressMonitor);
                    }
                    catch (Exception checkerror) {
                        isSelfException = true;
                        throw new Exception(checkerror.getMessage());
                    }
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] Selenium WebDriver \u00fcber ChromeDriver wird gestartet ...");
                MonitorLog.invoke((Object)MonitorLog, "Selenium WebDriver \u00fcber ChromeDriver wird gestartet ...");
                driver = new ChromeDriver(options);
            }
            catch (WebDriverException driverException) {
                block126: {
                    String[] driverExceptionString = driverException.getMessage().split("\r\n|\r|\n|" + System.lineSeparator());
                    for (String exceptionString : driverExceptionString) {
                        LogTrace.invoke((Object)LogTrace, "[WebSync:ChromeDriverWebClientInit] driverExceptionString Slit: " + exceptionString);
                    }
                    String shortException = driverExceptionString[0] + " " + driverExceptionString[1];
                    LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Erst-Initialisierung von ChromeDriver fehlgeschlagen, reagiere auf Exception:  " + shortException);
                    if (!shortException.contains("cannot find Chrome binary") && !shortException.contains("chrome not reachable") && !shortException.contains("Chrome version must be ") && !shortException.contains("This version of ChromeDriver only supports Chrome version") && !shortException.contains("DevToolsActivePort file doesn")) break block126;
                    LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] -> Erst-Initialisierung des WebDriver nicht erfolgreich, der Start dauert daher l\u00e4nger:");
                    MonitorLog.invoke((Object)MonitorLog, "-> Erst-Initialisierung des WebDriver nicht erfolgreich, der Start dauert daher l\u00e4nger:");
                    try {
                        block129: {
                            block127: {
                                String errorMsg;
                                block128: {
                                    if (extractRootPath.exists() && !shortException.contains("Chrome version must be ") && !shortException.contains("This version of ChromeDriver only supports Chrome version") && !shortException.contains("DevToolsActivePort file doesn")) break block127;
                                    errorMsg = shortException.trim();
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] errorMsg substring(31,69): " + errorMsg);
                                    if (extractRootPath.exists() || !shortException.contains("Chrome version must be ") && !shortException.contains("This version of ChromeDriver only supports Chrome version") && !shortException.contains("DevToolsActivePort file doesn")) break block128;
                                    LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Chrome/Chromium liegt in einer nicht kompatiblen Version vor (Fehler: " + errorMsg + "). Dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt wenn Chrome in einer kompatiblen Version gefunden wird!)");
                                    MonitorLog.invoke((Object)MonitorLog, "Hinweis: Chrome/Chromium liegt in einer nicht kompatiblen Version vor (Fehler: " + errorMsg + ") ...");
                                    MonitorLog.invoke((Object)MonitorLog, "... dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Chrome in einer kompatiblen Version gefunden wird!)");
                                    try {
                                        ChromeDriverUtils.getChromiumBrowser(externalLogger, externalProgressMonitor);
                                    }
                                    catch (Exception error) {
                                        isSelfException = true;
                                        throw new Exception(error);
                                    }
                                    freshChrome = true;
                                    break block129;
                                }
                                if (extractRootPath.exists() && (shortException.contains("Chrome version must be ") || shortException.contains("This version of ChromeDriver only supports Chrome version") || shortException.contains("DevToolsActivePort file doesn"))) {
                                    LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Chrome/Chromium liegt in einer nicht kompatiblen Version vor (Fehler: " + errorMsg + "). Daher wird nun der automatisch nachgeladene Chromium verwendet ... (dieser wird wieder entfernt, wenn Chrome in einer kompatiblen Version gefunden wird!)");
                                    MonitorLog.invoke((Object)MonitorLog, "Hinweis: Chrome/Chromium liegt in einer nicht kompatiblen Version vor (Fehler: " + errorMsg + ") ...");
                                    MonitorLog.invoke((Object)MonitorLog, "... daher wird nun der automatisch nachgeladene Chromium verwendet ... (dieser wird wieder entfernt wenn Chrome in einer kompatiblen Version gefunden wird!)");
                                    break block129;
                                } else {
                                    LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Chrome/Chromium konnte nicht gefunden werden. Dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Chrome gefunden wird!)");
                                    MonitorLog.invoke((Object)MonitorLog, "Hinweis: Chrome/Chromium konnte nicht gefunden werden ...");
                                    MonitorLog.invoke((Object)MonitorLog, "... dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Chrome gefunden wird!)");
                                    try {
                                        ChromeDriverUtils.getChromiumBrowser(externalLogger, externalProgressMonitor);
                                    }
                                    catch (Exception error) {
                                        isSelfException = true;
                                        throw new Exception(error);
                                    }
                                    freshChrome = true;
                                }
                                break block129;
                            }
                            LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] -> Sie verwenden bereits den alternativen Chromium-Browser. Info: Google Chrome beschleunigt den WebDriver-Start!");
                            MonitorLog.invoke((Object)MonitorLog, "-> Sie verwenden bereits den alternativen Chromium-Browser. Info: Google Chrome beschleunigt den WebDriver-Start!");
                        }
                        try {
                            ChromeDriverWebClientInit.checkChromiumBinary(externalLogger);
                        }
                        catch (Exception checkererror) {
                            LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Alternative Chromium-Binary fehlerhaft oder nicht korrekt (Existiert nicht, keine Datei). Chromium wird daher nun neu geladen ... (und wird wieder entfernt, wenn Chrome gefunden wird!)");
                            MonitorLog.invoke((Object)MonitorLog, "Hinweis: Alternative Chromium-Binary fehlerhaft oder nicht korrekt (Existiert nicht, keine Datei) ...");
                            MonitorLog.invoke((Object)MonitorLog, "Chromium wird daher nun neu geladen ... (und wird wieder entfernt, wenn Chrome gefunden wird!)");
                            try {
                                ChromeDriverUtils.getChromiumBrowser(externalLogger, externalProgressMonitor);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception(error);
                            }
                            freshChrome = true;
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Setze Pfad zur alternativen Chromium-Binary: " + rawChromiumBinaryPath);
                        options.setBinary(rawChromiumBinaryPath);
                        alternativeChromiumBrowserIsUsed = true;
                        try {
                            ChromeDriverUtils.secuityCheckOfBrowser(externalLogger, externalProgressMonitor);
                        }
                        catch (Exception checkerror) {
                            isSelfException = true;
                            throw new Exception(checkerror.getMessage());
                        }
                        try {
                            driver = new ChromeDriver(options);
                        }
                        catch (Exception ownChromiumDriverExcption) {
                            String shortExceptionOwnChromium = ownChromiumDriverExcption.getMessage().split("\r\n|\r|\n|" + System.lineSeparator(), 2)[0];
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] Initialisierung des alternativen Chromium fehlgeschlagen, reagiere auf Exception:  " + shortExceptionOwnChromium);
                            if (extractRootPath.exists() && (shortExceptionOwnChromium.contains("Chrome version must be ") || shortExceptionOwnChromium.contains("This version of ChromeDriver only supports Chrome version"))) {
                                LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Alternativer Chromium liegt in einer nicht kompatiblen Version vor (Fehler: " + shortExceptionOwnChromium + "). Dieser wird daher nun automatisch aktualisiert ... (und wird wieder entfernt, wenn Chrome in einer kompatiblen Version gefunden wird!)");
                                MonitorLog.invoke((Object)MonitorLog, "Hinweis: Alternativer Chromium liegt in einer nicht kompatiblen Version vor (Fehler: " + shortExceptionOwnChromium + ") ...");
                                MonitorLog.invoke((Object)MonitorLog, "... dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Chrome in einer kompatiblen Version gefunden wird!)");
                                try {
                                    ChromeDriverUtils.getChromiumBrowser(externalLogger, externalProgressMonitor);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception(error);
                                }
                                freshChrome = true;
                            } else if (!extractRootPath.exists()) {
                                LogWarn.invoke((Object)LogWarn, "[WebSync:ChromeDriverWebClientInit] Alternativer Chromium konnte nicht gefunden werden. Dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Chrome gefunden wird!)");
                                MonitorLog.invoke((Object)MonitorLog, "Hinweis: Alternativer Chromium konnte nicht gefunden werden ...");
                                MonitorLog.invoke((Object)MonitorLog, "... dieser wird daher nun automatisch nachgeladen ... (und wird wieder entfernt, wenn Chrome gefunden wird!)");
                                try {
                                    ChromeDriverUtils.getChromiumBrowser(externalLogger, externalProgressMonitor);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception(error);
                                }
                                freshChrome = true;
                            }
                            freshChrome = true;
                            driver = new ChromeDriver(options);
                        }
                    }
                    catch (Exception loaderror) {
                        if (isSelfException) {
                            throw new Exception(loaderror.getMessage());
                        }
                        isSelfException = true;
                        throw new Exception("Laden des alternativen Chromium fehlgeschlagen! " + ExceptionUtils.getStackTrace((Throwable)loaderror));
                    }
                }
                if (extractRootPath.exists() && !forceUseAlterateBrowser) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] Hinweis: Chrome gefunden. Alternativer Chromium wird daher nun wieder entfernt ...");
                    MonitorLog.invoke((Object)MonitorLog, "Hinweis: Chrome gefunden. Alternativer Chromium wird daher nun wieder entfernt ...");
                    FileUtils.forceDelete((File)extractRootPath);
                }
                isSelfException = true;
                throw new Exception(ExceptionUtils.getStackTrace((Throwable)driverException));
            }
            try {
                if (!freshChrome) {
                    ChromiumVersion.checkAndSet((RemoteWebDriver)driver, alternativeChromiumBrowserIsUsed, externalLogger, externalProgressMonitor);
                }
            }
            catch (Exception versionErr) {
                SeleniumUtils.quitBrowserDriver(driver, externalLogger);
                if (!versionErr.getMessage().equals("newDownloadHaveToReinitialize")) {
                    isSelfException = true;
                    throw new Exception(versionErr.getMessage());
                }
                try {
                    ChromeDriverWebClientInit.checkChromiumBinary(externalLogger);
                }
                catch (Exception checkererror) {
                    isSelfException = true;
                    throw new Exception(checkererror.getMessage());
                }
                options.setBinary(rawChromiumBinaryPath);
                alternativeChromiumBrowserIsUsed = true;
                try {
                    ChromeDriverUtils.secuityCheckOfBrowser(externalLogger, externalProgressMonitor);
                }
                catch (Exception checkerror) {
                    isSelfException = true;
                    throw new Exception(checkerror.getMessage());
                }
                driver = new ChromeDriver(options);
            }
            if (extractRootPath.exists() && !alternativeChromiumBrowserIsUsed) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] Chrome gefunden. Alternativer Chromium wird daher nun wieder entfernt ...");
                MonitorLog.invoke((Object)MonitorLog, "Chrome gefunden. Alternativer Chromium wird daher nun wieder entfernt ...");
                FileSysUtils.forceDeleteTarget(extractRootPath);
            }
            if (!StringCharUtils.isNullOrEmptyOrNothing(loadExtention) && loadExtention.equals("ca\u00admou\u00adf\u00adla\u00adge-mode")) {
                JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
                String currentUserAgent = String.valueOf(jsExecutor.executeScript("return navigator.userAgent", new Object[0]));
                SeleniumUtils.quitBrowserDriver(driver, externalLogger);
                String camouflageUserAgent = currentUserAgent.replace("Headless", "");
                ArrayList<String> postComlineArgs = new ArrayList<String>();
                postComlineArgs.add("--user-agent=" + camouflageUserAgent);
                options.addArguments(postComlineArgs);
                driver = new ChromeDriver(options);
                jsExecutor = (JavascriptExecutor)driver;
                String string = String.valueOf(jsExecutor.executeScript("return navigator.userAgent", new Object[0]));
            }
            TimeUnit.SECONDS.sleep(2L);
            driver.manage().timeouts().scriptTimeout(Duration.ofSeconds(60L));
            driver.manage().timeouts().pageLoadTimeout(Duration.ofSeconds(120L));
            if (headlessMode) {
                // empty if block
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] ChromeDriver-Webclient wurde erfolgreich vorbereitet");
            LogInfo.invoke((Object)LogInfo, "[WebSync:ChromeDriverWebClientInit] WebDriver-Info: Session-ID: " + ((RemoteWebDriver)driver).getSessionId());
        }
        catch (Exception error) {
            SeleniumUtils.quitBrowserDriver(driver, externalLogger);
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Erstellen des WebClient fehlgeschlagen!\nStacktrace: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        String userAgent = (String)((JavascriptExecutor)driver).executeScript("return navigator.userAgent;", new Object[0]);
        LogDebug.invoke((Object)LogDebug, "[WebSync:ChromeDriverWebClientInit] WebDriver-Info: UserAgent = " + userAgent);
        return driver;
    }

    private static void checkChromiumBinary(Class<?> externalLogger) throws Exception {
        try {
            if (StringCharUtils.isNullOrEmptyOrNothing(rawChromiumBinaryPath)) {
                throw new Exception("Pfad zur Chromium-Binary ist leer! Bitte setzen Sie f\u00fcr Java 'System.setProperty(\"chromium.binary.path\", <Pfad zur Binary>);'");
            }
            File chromiumBinary = new File(rawChromiumBinaryPath);
            if (!chromiumBinary.exists() && rawChromiumBinaryPath.endsWith("chrome-win32\\chrome.exe")) {
                rawChromiumBinaryPath = rawChromiumBinaryPath.replace("chrome-win32", "chrome-win");
                chromiumBinary = new File(rawChromiumBinaryPath);
            } else if (!chromiumBinary.exists() && rawChromiumBinaryPath.endsWith("chrome-win\\chrome.exe")) {
                rawChromiumBinaryPath = rawChromiumBinaryPath.replace("chrome-win", "chrome-win32");
                chromiumBinary = new File(rawChromiumBinaryPath);
            }
            if (!chromiumBinary.exists() && !forceUseAlterateBrowser) {
                throw new Exception("Pfad zur Chromium-Binary scheint nicht korrekt. (Existiert nicht) Bitte \u00fcberpr\u00fcfen Sie diesen: " + chromiumBinary.getCanonicalPath());
            }
            if (!chromiumBinary.isFile() && !forceUseAlterateBrowser) {
                throw new Exception("Pfad zur Chromium-Binary scheint nicht korrekt. (Keine Datei) Bitte \u00fcberpr\u00fcfen Sie diesen: " + chromiumBinary.getCanonicalPath());
            }
            if (!chromiumBinary.exists() && !forceUseAlterateBrowser) {
                throw new Exception("Pfad zur Chromium-Binary scheint nicht korrekt. (Existiert nicht) Bitte \u00fcberpr\u00fcfen Sie diesen: " + chromiumBinary.getCanonicalPath());
            }
            if (!chromiumBinary.isFile() && !forceUseAlterateBrowser) {
                throw new Exception("Pfad zur Chromium-Binary scheint nicht korrekt. (Keine Datei) Bitte \u00fcberpr\u00fcfen Sie diesen: " + chromiumBinary.getCanonicalPath());
            }
        }
        catch (Exception error) {
            SeleniumUtils.quitBrowserDriver(driver, externalLogger);
            throw new Exception(error.getMessage());
        }
    }

    static {
        rawChromeDriverBinaryPath = System.getProperty("chromedriver.binary.path");
        rawChromeDriverLogPath = System.getProperty("chromedriver.logfile.path");
        rawChromiumRootPath = System.getProperty("chromium.root.path");
        rawChromiumBinaryPath = System.getProperty("chromium.binary.path");
        rawChromeDownloadsPath = System.getProperty("selenium.downloads.path");
        forceUseAlterateBrowser = Boolean.parseBoolean(System.getProperty("selenium.forceuse.alternatebrowser"));
    }
}

