/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync;

import org.htmlunit.WebClient;
import org.htmlunit.html.HtmlPage;

public final class Version {
    private Version() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 1 && "-SanityCheck".equals(args[0])) {
            Version.runSanityCheck();
            return;
        }
        System.out.println(Version.getProductName());
        System.out.println(Version.getCopyright());
        System.out.println("Version: " + Version.getProductVersion());
    }

    private static void runSanityCheck() throws Exception {
        try (WebClient webClient = new WebClient();){
            HtmlPage page = (HtmlPage)webClient.getPage("https://scripting-updates.derrichter.de/index.html");
            System.out.println("Sanity check complete.");
        }
    }

    public static String getProductName() {
        return "Finance.Websync";
    }

    public static String getProductVersion() {
        return Version.class.getPackage().getImplementationVersion();
    }

    public static String getCopyright() {
        return "Copyright (c) 2010-2023 Finance.Websync Project. All rights reserved.";
    }
}

