/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.SEPA.Basislastschrift;

import de.jost_net.OBanToo.SEPA.BIC;
import de.jost_net.OBanToo.SEPA.Basislastschrift.MandatSequence;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.SequenceType1Code;
import de.jost_net.OBanToo.SEPA.SEPAException;
import de.jost_net.OBanToo.StringLatin.Zeichen;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;

public class Zahler {
    private String mandatid;
    private Date mandatdatum;
    private String bic;
    private String name;
    private String nameorig;
    private String iban;
    private String verwendungszweck;
    private String verwendungszweckorig;
    private BigDecimal betrag;
    private MandatSequence mandatsequence;
    private Date faelligkeit;
    private static final BigDecimal nu = new BigDecimal("0.00");
    private int verwendungszwecke = 0;

    public String getMandatid() throws SEPAException {
        this.checkMandatID(this.mandatid);
        return this.mandatid;
    }

    public void setMandatid(String mandatid) throws SEPAException {
        this.checkMandatID(mandatid);
        this.mandatid = mandatid;
    }

    private void checkMandatID(String mandatid) throws SEPAException {
        if (mandatid == null || mandatid.length() == 0 || mandatid.length() > 35) {
            throw new SEPAException("Ung\u00fcltige Mandat-ID: " + mandatid);
        }
    }

    public Date getMandatdatum() throws SEPAException {
        this.checkMandatdatum(this.mandatdatum);
        return this.mandatdatum;
    }

    public void setMandatdatum(Date mandatdatum) throws SEPAException {
        this.checkMandatdatum(mandatdatum);
        this.mandatdatum = mandatdatum;
    }

    private void checkMandatdatum(Date mandatdatum) throws SEPAException {
        if (mandatdatum == null || mandatdatum.after(new Date())) {
            throw new SEPAException("Ung\u00fcltiges Mandatdatum: " + mandatdatum);
        }
    }

    public String getBic() throws SEPAException {
        this.checkBic(this.bic);
        return this.bic;
    }

    public void setBic(String bic) throws SEPAException {
        this.checkBic(bic);
        this.bic = bic;
    }

    private void checkBic(String bic) throws SEPAException {
        new BIC(bic);
    }

    public String getName() throws SEPAException {
        this.checkName(this.name);
        return this.name;
    }

    public String getNameOrig() throws SEPAException {
        this.checkName(this.nameorig);
        return this.nameorig;
    }

    public void setName(String name) throws SEPAException {
        String tmpName = Zeichen.convert(name);
        this.checkName(tmpName);
        this.name = tmpName;
        this.nameorig = name;
    }

    private void checkName(String name) throws SEPAException {
        if (name == null || name.length() == 0 || name.length() > 70) {
            throw new SEPAException("Ung\u00fcltiger Name: " + name);
        }
    }

    public String getIban() throws SEPAException {
        new IBAN(this.iban);
        return this.iban;
    }

    public void setIban(String iban) throws SEPAException {
        new IBAN(iban);
        this.iban = iban;
    }

    public String getVerwendungszweck() throws SEPAException {
        this.checkVerwendungszweck(this.verwendungszweck);
        return this.verwendungszweck;
    }

    public String getVerwendungszweckOrig() throws SEPAException {
        this.checkVerwendungszweck(this.verwendungszweckorig);
        return this.verwendungszweckorig;
    }

    public void setVerwendungszweck(String verwendungszweck) throws SEPAException {
        String tmpVerwendungszweck = Zeichen.convert(verwendungszweck);
        this.verwendungszwecke = 1;
        this.checkVerwendungszweck(tmpVerwendungszweck);
        this.verwendungszweck = tmpVerwendungszweck;
        this.verwendungszweckorig = verwendungszweck;
    }

    private void checkVerwendungszweck(String verwendungszweck) throws SEPAException {
        if (verwendungszweck == null || verwendungszweck.length() == 0 || verwendungszweck.length() > 140) {
            throw new SEPAException("Ung\u00fcltiger Verwendungszweck: " + verwendungszweck);
        }
    }

    public BigDecimal getBetrag() throws SEPAException {
        this.checkBetrag(this.betrag);
        return this.betrag;
    }

    public void setBetrag(BigDecimal betrag) throws SEPAException {
        this.checkBetrag(betrag);
        this.betrag = betrag;
    }

    public void checkBetrag(BigDecimal betrag) throws SEPAException {
        if (betrag == null || betrag.compareTo(nu) == 0) {
            throw new SEPAException("Ung\u00fcltiger Betrag: " + betrag);
        }
    }

    public void setMandatsequence(MandatSequence sequence) {
        this.mandatsequence = sequence;
    }

    public MandatSequence getMandatsequence() throws SEPAException {
        this.checkMandatsequence(this.mandatsequence);
        return this.mandatsequence;
    }

    public void checkMandatsequence(MandatSequence seq) throws SEPAException {
        if (seq == null) {
            throw new SEPAException("Mandats-Sequence ist null");
        }
    }

    public Date getFaelligkeit() throws SEPAException {
        this.checkFaelligkeit(this.faelligkeit);
        return this.faelligkeit;
    }

    public void setFaelligkeit(Date faelligkeit) {
        this.faelligkeit = faelligkeit;
    }

    public void setFaelligkeit(Date faelligkeit1, Date faelligkeit2, SequenceType1Code sequ) {
        switch (sequ) {
            case FRST: 
            case OOFF: {
                this.setFaelligkeit(faelligkeit1);
                break;
            }
            case RCUR: 
            case FNAL: {
                this.setFaelligkeit(faelligkeit2);
            }
        }
    }

    public void checkFaelligkeit(Date faelligkeit) throws SEPAException {
        if (faelligkeit == null) {
            throw new SEPAException("F\u00e4lligkeit ist null");
        }
    }

    public void add(Zahler zahler) throws SEPAException {
        if (this.verwendungszweck == null) {
            this.verwendungszweck = "";
            this.verwendungszweckorig = "";
            this.verwendungszwecke = 1;
        }
        if (this.verwendungszwecke == 1) {
            this.verwendungszweck = this.verwendungszweck + " " + this.getBetrag();
        }
        if (this.verwendungszweck != null) {
            ++this.verwendungszwecke;
        }
        this.betrag = this.betrag.add(zahler.getBetrag());
        if (this.betrag.compareTo(new BigDecimal("0.00")) == -1) {
            throw new SEPAException("Ung\u00fcltiger Betrag: " + this.betrag);
        }
        if (this.verwendungszweck.length() == 140 && this.verwendungszweck.endsWith("...")) {
            return;
        }
        String tmpverwendungszweck = this.verwendungszweck + ", " + zahler.getVerwendungszweck() + " " + zahler.getBetrag();
        if (tmpverwendungszweck.length() > 140) {
            tmpverwendungszweck = tmpverwendungszweck.substring(0, 137) + "...";
        }
        this.verwendungszweck = tmpverwendungszweck;
    }

    public String toString() {
        String message = "";
        try {
            message = MessageFormat.format("Zahler: Name={0}, IBAN={1}, BIC={2}, Verwendungszweck={3}, Betrag={4}, Mandatdatum={5}, Mandatreferenz={6}", this.getName(), this.getIban(), this.getBic(), this.getVerwendungszweck(), this.getBetrag(), this.getMandatdatum(), this.getMandatid());
        }
        catch (SEPAException e) {
            message = e.getMessage();
        }
        return message;
    }
}

