/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.SEPA.Basislastschrift;

import de.jost_net.OBanToo.SEPA.Basislastschrift.Zahler;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.AccountIdentificationSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.ActiveOrHistoricCurrencyAndAmountSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.ActiveOrHistoricCurrencyCodeEUR;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.BranchAndFinancialInstitutionIdentificationSEPA1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.CashAccountSEPA1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.CashAccountSEPA2;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.ChargeBearerTypeSEPACode;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.CustomerDirectDebitInitiationV02;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.DirectDebitTransactionInformationSDD;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.DirectDebitTransactionSDD;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.Document;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.FinancialInstitutionIdentificationSEPA1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.GroupHeaderSDD;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.IdentificationSchemeNameSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.LocalInstrumentSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.LocalInstrumentSEPACode;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.MandateRelatedInformationSDD;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PartyIdentificationSEPA1;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PartyIdentificationSEPA2;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PartyIdentificationSEPA3;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PartyIdentificationSEPA5;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PartySEPA2;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PaymentIdentificationSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PaymentInstructionInformationSDD;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PaymentMethod2Code;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PaymentTypeInformationSDD;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.PersonIdentificationSEPA2;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.RemittanceInformationSEPA1Choice;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.RestrictedPersonIdentificationSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.RestrictedPersonIdentificationSchemeNameSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.SequenceType1Code;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.ServiceLevelSEPA;
import de.jost_net.OBanToo.SEPA.Nachricht.pain_008_002_02.ServiceLevelSEPACode;
import de.jost_net.OBanToo.SEPA.SEPAException;
import de.jost_net.OBanToo.StringLatin.Zeichen;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class Basislastschrift {
    private String messageID = null;
    private String bic = null;
    private String iban = null;
    private String name = null;
    private String glaeubigerid = null;
    private ArrayList<Zahler> zahlerarray = new ArrayList();
    private HashMap<String, Zahler> zahlermap = new HashMap();
    private BigDecimal kontrollsumme = new BigDecimal(0);
    private boolean komprimiert = false;
    private String anzahlbuchungen;
    private Date creationdatetime;

    public void add(Zahler zahler) throws SEPAException {
        if (this.komprimiert) {
            Zahler z = this.zahlermap.get(zahler.getMandatid());
            if (z == null) {
                if (zahler.getBetrag().compareTo(new BigDecimal("0.00")) == -1) {
                    throw new SEPAException("Ung\u00fcltiger Betrag: " + zahler.getBetrag());
                }
                this.zahlermap.put(zahler.getMandatid(), zahler);
            } else {
                z.add(zahler);
            }
        } else {
            if (zahler.getBetrag().compareTo(new BigDecimal("0")) == -1) {
                throw new SEPAException("Ung\u00fcltiger Betrag: " + zahler.getBetrag());
            }
            this.zahlerarray.add(zahler);
        }
    }

    public void write(File file) throws DatatypeConfigurationException, SEPAException, JAXBException {
        if (this.komprimiert) {
            Iterator<Map.Entry<String, Zahler>> es = this.zahlermap.entrySet().iterator();
            while (es.hasNext()) {
                Zahler zahler = es.next().getValue();
                this.zahlerarray.add(zahler);
            }
        }
        Document doc = new Document();
        doc.setCstmrDrctDbtInitn(this.getCustumerDirectDebitInitiationV02());
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Document.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.schemaLocation", (Object)"urn:iso:std:iso:20022:tech:xsd:pain.008.002.02 pain.008.002.02.xsd");
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)doc, file);
    }

    public void read(File file) throws JAXBException, SEPAException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Document.class});
        Unmarshaller u = jc.createUnmarshaller();
        Document doc = (Document)u.unmarshal(file);
        this.setMessageID(doc.getCstmrDrctDbtInitn().getGrpHdr().getMsgId());
        this.setName(doc.getCstmrDrctDbtInitn().getPmtInf().get(0).getCdtr().getNm());
        this.setIBAN(doc.getCstmrDrctDbtInitn().getPmtInf().get(0).getCdtrAcct().getId().getIBAN());
        int anzahlbuchungen = 0;
        BigDecimal kontrollsumme = new BigDecimal(0);
        for (PaymentInstructionInformationSDD pii : doc.getCstmrDrctDbtInitn().getPmtInf()) {
            anzahlbuchungen += new Integer(pii.getNbOfTxs()).intValue();
            this.setBIC(pii.getCdtrAgt().getFinInstnId().getBIC());
            kontrollsumme = kontrollsumme.add(pii.getCtrlSum());
            this.setCreationDateTime(doc.getCstmrDrctDbtInitn().getGrpHdr().getCreDtTm().toGregorianCalendar().getTime());
            this.setGlaeubigerID(pii.getCdtrSchmeId().getId().getPrvtId().getOthr().getId());
            this.setGlaeubigerID(doc.getCstmrDrctDbtInitn().getGrpHdr().getInitgPty().getId().getPrvtId().getOthr().getId());
            System.out.println(pii.getCdtrSchmeId().getId().getPrvtId().getOthr().getId());
            System.out.println(doc.getCstmrDrctDbtInitn().getGrpHdr().getInitgPty().getId().getPrvtId().getOthr().getId());
            List<DirectDebitTransactionInformationSDD> liste = pii.getDrctDbtTxInf();
            for (DirectDebitTransactionInformationSDD ddti : liste) {
                Zahler z = new Zahler();
                z.setBetrag(ddti.getInstdAmt().getValue());
                z.setBic(ddti.getDbtrAgt().getFinInstnId().getBIC());
                z.setIban(ddti.getDbtrAcct().getId().getIBAN());
                z.setMandatdatum(ddti.getDrctDbtTx().getMndtRltdInf().getDtOfSgntr().toGregorianCalendar().getTime());
                z.setMandatid(ddti.getPmtId().getEndToEndId());
                z.setName(ddti.getDbtr().getNm());
                z.setVerwendungszweck(ddti.getRmtInf().getUstrd());
                this.zahlerarray.add(z);
                this.zahlermap.put(z.getMandatid(), z);
            }
        }
        this.setAnzahlBuchungen(anzahlbuchungen + "");
        this.setKontrollsumme(kontrollsumme);
    }

    private CustomerDirectDebitInitiationV02 getCustumerDirectDebitInitiationV02() throws DatatypeConfigurationException, SEPAException {
        CustomerDirectDebitInitiationV02 cddi = new CustomerDirectDebitInitiationV02();
        for (Zahler z : this.zahlerarray) {
            this.kontrollsumme = this.kontrollsumme.add(z.getBetrag());
        }
        cddi.setGrpHdr(this.getGroupHeader());
        for (SequenceType1Code sequ : SequenceType1Code.values()) {
            PaymentInstructionInformationSDD pmtinstinf = this.getPaymentInstructionInformationSDD(sequ);
            if (new Integer(pmtinstinf.getNbOfTxs()) <= 0) continue;
            cddi.getPmtInf().add(pmtinstinf);
        }
        return cddi;
    }

    private GroupHeaderSDD getGroupHeader() throws DatatypeConfigurationException, SEPAException {
        GroupHeaderSDD grH = new GroupHeaderSDD();
        this.creationdatetime = new Date();
        grH.setCreDtTm(Basislastschrift.getYYYMMDDHHMMSS(this.creationdatetime));
        grH.setCtrlSum(this.kontrollsumme);
        PartyIdentificationSEPA1 partyid1 = new PartyIdentificationSEPA1();
        partyid1.setNm(Zeichen.convert(this.getName()));
        grH.setInitgPty(partyid1);
        grH.setMsgId(this.getMessageID());
        grH.setNbOfTxs(this.zahlerarray.size() + "");
        this.anzahlbuchungen = this.zahlerarray.size() + "";
        return grH;
    }

    private PaymentInstructionInformationSDD getPaymentInstructionInformationSDD(SequenceType1Code sequence) throws SEPAException, DatatypeConfigurationException {
        PaymentInstructionInformationSDD pii = new PaymentInstructionInformationSDD();
        pii.setBtchBookg(true);
        PartyIdentificationSEPA5 pi5 = new PartyIdentificationSEPA5();
        pi5.setNm(Zeichen.convert(this.getName()));
        pii.setCdtr(pi5);
        CashAccountSEPA1 ca1 = new CashAccountSEPA1();
        AccountIdentificationSEPA ai = new AccountIdentificationSEPA();
        ai.setIBAN(this.getIBAN());
        ca1.setId(ai);
        pii.setCdtrAcct(ca1);
        BranchAndFinancialInstitutionIdentificationSEPA1 bafii = new BranchAndFinancialInstitutionIdentificationSEPA1();
        FinancialInstitutionIdentificationSEPA1 fii = new FinancialInstitutionIdentificationSEPA1();
        fii.setBIC(this.getBIC());
        bafii.setFinInstnId(fii);
        pii.setCdtrAgt(bafii);
        PartySEPA2 p2 = new PartySEPA2();
        RestrictedPersonIdentificationSEPA rpi = new RestrictedPersonIdentificationSEPA();
        rpi.setId(this.getGlaeubigerID());
        RestrictedPersonIdentificationSchemeNameSEPA rpisn = new RestrictedPersonIdentificationSchemeNameSEPA();
        rpisn.setPrtry(IdentificationSchemeNameSEPA.SEPA);
        rpi.setSchmeNm(rpisn);
        PersonIdentificationSEPA2 pi2 = new PersonIdentificationSEPA2();
        pi2.setOthr(rpi);
        p2.setPrvtId(pi2);
        pii.setChrgBr(ChargeBearerTypeSEPACode.SLEV);
        pii.setPmtInfId(this.getMessageID());
        pii.setPmtMtd(PaymentMethod2Code.DD);
        pii.setPmtTpInf(this.getPaymentTypeInformationSDD(sequence));
        BigDecimal seqKontrollsumme = new BigDecimal(0);
        int seqAnzahl = 0;
        for (Zahler z : this.zahlerarray) {
            if (z.getMandatsequence().getCode().compareTo(sequence) != 0) continue;
            pii.setReqdColltnDt(Basislastschrift.getYYYMMDD(z.getFaelligkeit()));
            pii.getDrctDbtTxInf().add(this.getDirectDebitTransactionInformationSDD(z));
            seqKontrollsumme = seqKontrollsumme.add(z.getBetrag());
            ++seqAnzahl;
        }
        pii.setCtrlSum(seqKontrollsumme);
        pii.setNbOfTxs(seqAnzahl + "");
        return pii;
    }

    private static XMLGregorianCalendar getYYYMMDD(Date date) throws DatatypeConfigurationException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        XMLGregorianCalendar xmlgc = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
        xmlGregorianCalendar.setDay(xmlgc.getDay());
        xmlGregorianCalendar.setMonth(xmlgc.getMonth());
        xmlGregorianCalendar.setYear(xmlgc.getYear());
        return xmlGregorianCalendar;
    }

    private static XMLGregorianCalendar getYYYMMDDHHMMSS(Date date) throws DatatypeConfigurationException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        XMLGregorianCalendar xmlgc = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
        xmlGregorianCalendar.setDay(xmlgc.getDay());
        xmlGregorianCalendar.setMonth(xmlgc.getMonth());
        xmlGregorianCalendar.setYear(xmlgc.getYear());
        xmlGregorianCalendar.setHour(xmlgc.getHour());
        xmlGregorianCalendar.setMinute(xmlgc.getMinute());
        xmlGregorianCalendar.setSecond(xmlgc.getSecond());
        return xmlGregorianCalendar;
    }

    private DirectDebitTransactionInformationSDD getDirectDebitTransactionInformationSDD(Zahler z) throws DatatypeConfigurationException, SEPAException {
        DirectDebitTransactionInformationSDD ddti = new DirectDebitTransactionInformationSDD();
        PaymentIdentificationSEPA pis = new PaymentIdentificationSEPA();
        pis.setEndToEndId(z.getMandatid());
        ddti.setPmtId(pis);
        ActiveOrHistoricCurrencyAndAmountSEPA aohcaas = new ActiveOrHistoricCurrencyAndAmountSEPA();
        aohcaas.setCcy(ActiveOrHistoricCurrencyCodeEUR.EUR);
        aohcaas.setValue(z.getBetrag());
        ddti.setInstdAmt(aohcaas);
        DirectDebitTransactionSDD ddt = new DirectDebitTransactionSDD();
        MandateRelatedInformationSDD mri = new MandateRelatedInformationSDD();
        mri.setMndtId(z.getMandatid());
        mri.setDtOfSgntr(Basislastschrift.getYYYMMDD(z.getMandatdatum()));
        mri.setAmdmntInd(false);
        RestrictedPersonIdentificationSchemeNameSEPA rpisn = new RestrictedPersonIdentificationSchemeNameSEPA();
        rpisn.setPrtry(IdentificationSchemeNameSEPA.SEPA);
        RestrictedPersonIdentificationSEPA rpi = new RestrictedPersonIdentificationSEPA();
        rpi.setId(this.getGlaeubigerID());
        rpi.setSchmeNm(rpisn);
        PersonIdentificationSEPA2 pi2 = new PersonIdentificationSEPA2();
        pi2.setOthr(rpi);
        PartySEPA2 p2 = new PartySEPA2();
        p2.setPrvtId(pi2);
        PartyIdentificationSEPA3 pi3 = new PartyIdentificationSEPA3();
        pi3.setId(p2);
        ddt.setCdtrSchmeId(pi3);
        ddt.setMndtRltdInf(mri);
        ddti.setDrctDbtTx(ddt);
        BranchAndFinancialInstitutionIdentificationSEPA1 bafiis = new BranchAndFinancialInstitutionIdentificationSEPA1();
        FinancialInstitutionIdentificationSEPA1 fii = new FinancialInstitutionIdentificationSEPA1();
        fii.setBIC(z.getBic());
        bafiis.setFinInstnId(fii);
        ddti.setDbtrAgt(bafiis);
        PartyIdentificationSEPA2 pi22 = new PartyIdentificationSEPA2();
        pi22.setNm(Zeichen.convert(z.getName()));
        ddti.setDbtr(pi22);
        CashAccountSEPA2 ca2 = new CashAccountSEPA2();
        AccountIdentificationSEPA ais = new AccountIdentificationSEPA();
        ais.setIBAN(z.getIban());
        ca2.setId(ais);
        ddti.setDbtrAcct(ca2);
        RemittanceInformationSEPA1Choice ris = new RemittanceInformationSEPA1Choice();
        ris.setUstrd(z.getVerwendungszweck());
        ddti.setRmtInf(ris);
        return ddti;
    }

    private PaymentTypeInformationSDD getPaymentTypeInformationSDD(SequenceType1Code sequence) {
        PaymentTypeInformationSDD pti = new PaymentTypeInformationSDD();
        ServiceLevelSEPA sls = new ServiceLevelSEPA();
        sls.setCd(ServiceLevelSEPACode.SEPA);
        pti.setSvcLvl(sls);
        LocalInstrumentSEPA lis = new LocalInstrumentSEPA();
        lis.setCd(LocalInstrumentSEPACode.CORE);
        pti.setLclInstrm(lis);
        pti.setSeqTp(sequence);
        return pti;
    }

    public void setMessageID(String messageid) throws SEPAException {
        if (messageid == null || messageid.length() == 0 || messageid.length() > 35) {
            throw new SEPAException("Message-ID muss zwischen 1 und 35 Stellen lang sein");
        }
        this.messageID = messageid;
    }

    public String getMessageID() throws SEPAException {
        if (this.messageID == null) {
            throw new SEPAException("Message-ID ist noch nicht gef\u00fcllt");
        }
        return this.messageID;
    }

    public void setBIC(String bic) throws SEPAException {
        if (bic == null || bic.length() != 8 && bic.length() != 11) {
            throw new SEPAException("BIC nicht korrekt gef\u00fcllt");
        }
        this.bic = bic;
    }

    public String getBIC() throws SEPAException {
        if (this.bic == null) {
            throw new SEPAException("BIC ist noch nicht gef\u00fcllt");
        }
        return this.bic;
    }

    public void setIBAN(String iban) throws SEPAException {
        new IBAN(iban);
        this.iban = iban;
    }

    public String getIBAN() throws SEPAException {
        if (this.iban == null) {
            throw new SEPAException("IBAN ist noch nicht gef\u00fcllt");
        }
        return this.iban;
    }

    public void setName(String name) throws SEPAException {
        if (name == null || name.length() == 0 || name.length() > 70) {
            throw new SEPAException("Name des Zahlungsempf\u00e4ngers nicht korrekt gef\u00fcllt");
        }
        this.name = name;
    }

    public String getName() throws SEPAException {
        if (this.name == null) {
            throw new SEPAException("Name des Zahlungsempf\u00e4ngers ist noch nicht gef\u00fcllt");
        }
        return this.name;
    }

    public void setGlaeubigerID(String glaeubigerid) throws SEPAException {
        if (glaeubigerid == null || glaeubigerid.length() == 0) {
            throw new SEPAException("Gl\u00e4ubiger-ID nicht korrekt gef\u00fcllt");
        }
        this.glaeubigerid = glaeubigerid;
    }

    public String getGlaeubigerID() throws SEPAException {
        if (this.glaeubigerid == null) {
            throw new SEPAException("Gl\u00e4ubiger-ID ist noch nicht gef\u00fcllt");
        }
        return this.glaeubigerid;
    }

    public void setKomprimiert(boolean komprimiert) throws SEPAException {
        if (this.zahlerarray.size() > 0) {
            throw new SEPAException("Komprimierung kann nicht gesetzt werden, wenn schon Zahlungen \u00fcbergeben wurden.");
        }
        this.komprimiert = komprimiert;
    }

    void setKontrollsumme(BigDecimal kontrollsumme) {
        this.kontrollsumme = kontrollsumme;
    }

    public BigDecimal getKontrollsumme() {
        return this.kontrollsumme;
    }

    public String getAnzahlBuchungen() {
        return this.anzahlbuchungen;
    }

    void setAnzahlBuchungen(String anzahlbuchungen) {
        this.anzahlbuchungen = anzahlbuchungen;
    }

    public Date getCreationDateTime() {
        return this.creationdatetime;
    }

    void setCreationDateTime(Date creationdatetime) {
        this.creationdatetime = creationdatetime;
    }

    public ArrayList<Zahler> getZahler() {
        return this.zahlerarray;
    }
}

