/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.SEPA.BankenDaten;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;

public class BLZSatz {
    private BufferedInputStream bi;
    private String blz = null;
    private String zahlungsdienstleister = null;
    private String bezeichnung = null;
    private String plz = null;
    private String ort = null;
    private String kurzbezeichnung = null;
    private String institutsnummerPAN = null;
    private String bic = null;
    private String pruefziffernmethode = null;
    private String nummer = null;
    private String aenderungskennzeichen = null;
    private String hinweisloeschung = null;
    private String nachfolgeblz = null;
    private String ibanregel = null;
    private String zeile;
    private int pos = 0;

    public BLZSatz(BufferedReader br) throws IOException {
        this.zeile = br.readLine();
        if (this.zeile == null) {
            return;
        }
        this.blz = this.getString(8);
        this.zahlungsdienstleister = this.getString(1);
        this.bezeichnung = this.getString(58).trim();
        this.plz = this.getString(5);
        this.ort = this.getString(35);
        this.kurzbezeichnung = this.getString(27);
        this.institutsnummerPAN = this.getString(5);
        this.bic = this.getString(11);
        this.pruefziffernmethode = this.getString(2);
        this.nummer = this.getString(6);
        this.aenderungskennzeichen = this.getString(1);
        this.hinweisloeschung = this.getString(1);
        this.nachfolgeblz = this.getString(8);
        this.ibanregel = this.getString(6);
    }

    private String getString(int len) {
        String ret = this.zeile.substring(this.pos, this.pos + len);
        this.pos += len;
        return ret;
    }

    public String getBlz() {
        return this.blz;
    }

    public String getZahlungsdienstleister() {
        return this.zahlungsdienstleister;
    }

    public String getBezeichnung() {
        return this.bezeichnung;
    }

    public String getPlz() {
        return this.plz;
    }

    public String getOrt() {
        return this.ort;
    }

    public String getKurzbezeichnung() {
        return this.kurzbezeichnung;
    }

    public String getInstitutsnummerPAN() {
        return this.institutsnummerPAN;
    }

    public String getBic() {
        return this.bic;
    }

    public String getPruefziffernmethode() {
        return this.pruefziffernmethode;
    }

    public String getNummer() {
        return this.nummer;
    }

    public String getAenderungskennzeichen() {
        return this.aenderungskennzeichen;
    }

    public String getHinweisloeschung() {
        return this.hinweisloeschung;
    }

    public String getNachfolgeblz() {
        return this.nachfolgeblz;
    }

    public String getIBANRegel() {
        return this.ibanregel;
    }

    public boolean hasNext() throws IOException {
        return this.bi.available() > 0;
    }

    public String toString() {
        return this.blz + ", " + this.bic + ", " + this.bezeichnung + ", \u00c3\u0084nderungskennzeichen=" + this.aenderungskennzeichen + ", Hinweis L\u00f6schung=" + this.hinweisloeschung + ", Zahlungsdienstleister=" + this.zahlungsdienstleister;
    }
}

