/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.QIF;

import de.jost_net.OBanToo.Dtaus.Tool;
import de.jost_net.OBanToo.QIF.QIFException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class QIFBuchung {
    private Date datum = null;
    private double betrag = 0.0;
    private String empfaenger = null;
    private String kategorie = null;
    private String clearedStatus = null;
    private String referenz = null;
    private String memo = null;
    private Vector<String> adresse = new Vector();
    private int ai = -1;

    public void add(String line) throws QIFException {
        if (line.startsWith("D")) {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy");
            try {
                this.datum = sdf.parse(line.substring(1));
                return;
            }
            catch (ParseException parseException) {
                try {
                    this.datum = Tool.parseQIFDate(line.substring(1));
                    return;
                }
                catch (ParseException parseException2) {
                    throw new QIFException("Ung\u00fcltiges Datum: ", line.substring(1));
                }
            }
        }
        if (line.startsWith("T")) {
            this.betrag = Double.parseDouble(line.substring(1));
        }
        if (line.startsWith("P")) {
            this.empfaenger = line.substring(1);
        }
        if (line.startsWith("L")) {
            this.kategorie = line.substring(1);
        }
        if (line.startsWith("C")) {
            this.clearedStatus = line.substring(1);
        }
        if (line.startsWith("A")) {
            this.adresse.addElement(line.substring(1));
        }
        if (line.startsWith("N")) {
            this.referenz = line.substring(1);
        }
        if (line.startsWith("M")) {
            this.memo = line.substring(1);
        }
    }

    public Date getDatum() {
        return this.datum;
    }

    public void setDatum(Date value) {
        this.datum = value;
    }

    public double getBetrag() {
        return this.betrag;
    }

    public void setBetrag(double value) {
        this.betrag = value;
    }

    public String getEmpfaenger() {
        return this.empfaenger;
    }

    public void setEmpfaenger(String value) {
        this.empfaenger = value;
    }

    public String getKategorie() {
        return this.kategorie;
    }

    public void setKategorie(String value) {
        this.kategorie = value;
    }

    public String getClearedStatus() {
        return this.clearedStatus;
    }

    public void setClearedStatus(String value) {
        this.clearedStatus = value;
    }

    public String getReferenz() {
        return this.referenz;
    }

    public void setReferenz(String value) {
        this.referenz = value;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String value) {
        this.memo = value;
    }

    public int getAnzahlAdresszeilen() {
        return this.adresse.size();
    }

    public String getAdresseNext() {
        ++this.ai;
        if (this.ai >= this.adresse.size()) {
            return null;
        }
        return this.adresse.elementAt(this.ai);
    }

    public void addAdresse(String value) {
        this.adresse.addElement(value);
    }

    public void write(DataOutputStream dos) throws IOException {
        if (this.getDatum() != null) {
            dos.writeBytes("D" + Tool.formatQIFDate(this.getDatum()) + "\n");
        }
        dos.writeBytes("T" + Tool.formatQIFBetrag(this.getBetrag()) + "\n");
        if (this.getEmpfaenger() != null) {
            dos.writeBytes("P" + this.getEmpfaenger() + "\n");
        }
        if (this.getKategorie() != null) {
            dos.writeBytes("L" + this.getKategorie() + "\n");
        }
        if (this.getClearedStatus() != null) {
            dos.writeBytes("C" + this.getClearedStatus() + "\n");
        }
        this.ai = -1;
        for (int i = 0; i < this.getAnzahlAdresszeilen(); ++i) {
            dos.writeBytes("A" + this.getAdresseNext() + "\n");
        }
        if (this.getReferenz() != null) {
            dos.writeBytes("N" + this.getReferenz() + "\n");
        }
        if (this.getMemo() != null) {
            dos.writeBytes("M" + this.getMemo() + "\n");
        }
        dos.writeBytes("^\n");
    }

    public String toString() {
        String ret = "Datum=" + this.datum + ", Betrag=" + this.betrag + ", Empf\u00e4nger=" + this.empfaenger + ", Kategorie=" + this.kategorie + ", ClearedStatus=" + this.clearedStatus + ", Referenz=" + this.referenz + ", Memo=" + this.memo + ", Adresse=";
        for (int i = 0; i < this.adresse.size(); ++i) {
            ret = ret + this.adresse.elementAt(i) + ", ";
        }
        return ret;
    }
}

