/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.JUnit;

import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Land.SEPALaender;
import de.jost_net.OBanToo.SEPA.Land.SEPALand;
import de.jost_net.OBanToo.SEPA.SEPAException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TestSEPALand {
    @Test
    public void test01() {
        SEPALand sl = SEPALaender.getLand("DE");
        try {
            if (sl.check("DE12123")) {
                Assert.fail((String)"Ung\u00fcltige L\u00e4nge wurde nicht erkannt");
            }
        }
        catch (SEPAException sEPAException) {
            // empty catch block
        }
    }

    @Test
    public void test02() {
        SEPALand sl = SEPALaender.getLand("DE");
        try {
            sl.check("DE89370400440532013000");
        }
        catch (SEPAException e) {
            Assert.fail((String)"G\u00fcltige L\u00e4nge wurde als ung\u00fcltig erkannt");
        }
    }

    @Test
    public void test03() {
        SEPALand sl = SEPALaender.getLand("DE");
        try {
            sl.check("DE893A0400440532013000");
            Assert.fail((String)"Ung\u00fcltiges Zeichen nicht erkannt");
        }
        catch (SEPAException sEPAException) {
            // empty catch block
        }
    }

    @Test
    public void test04() {
        SEPALand sl = SEPALaender.getLand("DE");
        try {
            sl.check("DE8937040044053201300X");
            Assert.fail((String)"Ung\u00fcltiges Zeichen nicht erkannt");
        }
        catch (SEPAException sEPAException) {
            // empty catch block
        }
    }

    @Test
    public void test05() {
        SEPALand sl = SEPALaender.getLand("DE");
        try {
            sl.check("DE8937040044053201300X");
            Assert.fail((String)"Ung\u00fcltiges Zeichen nicht erkannt");
        }
        catch (SEPAException sEPAException) {
            // empty catch block
        }
    }

    @Test
    public void test06() {
        SEPALand sl = SEPALaender.getLand("BG");
        try {
            sl.check("BG800NBG96611020345678");
            Assert.fail((String)"Ung\u00fcltiges Zeichen nicht erkannt");
        }
        catch (SEPAException sEPAException) {
            // empty catch block
        }
    }

    @Test
    public void test07() {
        SEPALand sl = SEPALaender.getLand("BG");
        try {
            sl.check("BG800NBG9661102034567$");
            Assert.fail((String)"Ung\u00fcltiges Zeichen nicht erkannt");
        }
        catch (SEPAException sEPAException) {
            // empty catch block
        }
    }

    @Test
    public void test08() {
        for (SEPALand land : SEPALaender.getLaender()) {
            try {
                new IBAN(land.getIBANSample());
            }
            catch (SEPAException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }
}

