/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.Dtaus;

import de.jost_net.OBanToo.Dtaus.CSatz;
import de.jost_net.OBanToo.Dtaus.DtausException;
import de.jost_net.OBanToo.Dtaus.Satz;
import de.jost_net.OBanToo.Dtaus.Tool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ESatz
extends Satz {
    private String eSatzlaenge = "0128";
    private String eSatzart = "E";
    private int eAnzahlC = 0;
    private BigInteger eSummeKontonummern = new BigInteger("0");
    private BigInteger eSummeBankleitzahlen = new BigInteger("0");
    private BigInteger eSummeBetraege = new BigInteger("0");

    public ESatz() {
    }

    public ESatz(String satz, int toleranz) throws DtausException {
        satz = this.codingFromDtaus(satz, toleranz);
        try {
            this.validCharacters(satz);
        }
        catch (DtausException e) {
            throw new DtausException(e.getMessage() + " im E-Satz");
        }
        if (!satz.substring(0, 4).equals(this.eSatzlaenge)) {
            throw new DtausException("Satzl\u00e4ngenfeld des E-Satzes fehlerhaft: ");
        }
        if (!satz.substring(4, 5).equals(this.eSatzart)) {
            throw new DtausException("Satzart des E-Satzes fehlerhaft: ");
        }
        this.setAnzahlDatensaetze(satz.substring(10, 17));
        this.setSummeKontonummern(satz.substring(30, 47));
        this.setSummeBankleitzahlen(satz.substring(47, 64));
        this.setSummeBetraege(satz.substring(64, 77));
    }

    public void setAnzahlDatensaetze(String value) throws DtausException {
        try {
            this.eAnzahlC = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new DtausException("Anzahl der C-S\u00e4tze im E-Satz fehlerhaft: ", value);
        }
    }

    public int getAnzahlDatensaetze() {
        return this.eAnzahlC;
    }

    public void setSummeKontonummern(String value) {
        this.eSummeKontonummern = new BigInteger(value);
    }

    public BigInteger getSummeKontonummern() {
        return this.eSummeKontonummern;
    }

    public void setSummeBankleitzahlen(String value) {
        this.eSummeBankleitzahlen = new BigInteger(value);
    }

    public BigInteger getSummeBankleitzahlen() {
        return this.eSummeBankleitzahlen;
    }

    public void setSummeBetraege(String value) throws DtausException {
        try {
            this.eSummeBetraege = new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw new DtausException("Summe der Betr\u00e4ge im E-Satz fehlerhaft: ", value);
        }
    }

    public BigInteger getSummeBetraege() {
        return this.eSummeBetraege;
    }

    public void add(CSatz csatz) {
        ++this.eAnzahlC;
        this.eSummeBankleitzahlen = this.eSummeBankleitzahlen.add(new BigInteger(csatz.getBlzEndbeguenstigt() + ""));
        this.eSummeKontonummern = this.eSummeKontonummern.add(new BigInteger(csatz.getKontonummer() + ""));
        this.eSummeBetraege = this.eSummeBetraege.add(new BigInteger(csatz.getBetragInCent() + ""));
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeBytes("0128");
        dos.writeBytes("E");
        dos.writeBytes(Tool.space(5));
        dos.writeBytes(Tool.formatKontollAnzahl(this.eAnzahlC));
        dos.writeBytes(Tool.formatKontrollSumme(new BigInteger("0")));
        dos.writeBytes(Tool.formatKontroll17(this.eSummeKontonummern));
        dos.writeBytes(Tool.formatKontroll17(this.eSummeBankleitzahlen));
        dos.writeBytes(Tool.formatKontrollSumme(this.eSummeBetraege));
        dos.writeBytes(Tool.space(51));
    }

    public String toString() {
        return "Satzlaenge=" + this.eSatzlaenge + ", Satzart=" + this.eSatzart + ", Anzahl C-S\u00e4tze=" + this.eAnzahlC + ", Summe Kontonummern=" + this.eSummeKontonummern.toString() + ", Summe Bankleitzahlen=" + this.eSummeBankleitzahlen.toString() + ", Summe Betr\u00e4ge=" + this.eSummeBetraege;
    }
}

