/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.Dtaus;

import de.jost_net.OBanToo.Dtaus.ASatz;
import de.jost_net.OBanToo.Dtaus.CSatz;
import de.jost_net.OBanToo.Dtaus.DtausException;
import de.jost_net.OBanToo.Dtaus.ESatz;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DtausDateiWriter {
    private DataOutputStream dos;
    private ASatz asatz;
    private CSatz csatz;
    private ESatz esatz;

    public DtausDateiWriter(OutputStream os) {
        this.dos = new DataOutputStream(os);
        this.open();
    }

    public void open() {
        this.asatz = new ASatz();
        this.csatz = new CSatz();
        this.esatz = new ESatz();
    }

    public void close() throws IOException {
        this.dos.flush();
        this.dos.close();
    }

    public void setAGutschriftLastschrift(String aGutschriftLastschrift) throws DtausException {
        this.asatz.setGutschriftLastschrift(aGutschriftLastschrift);
    }

    public void setABLZBank(long aBLZBank) {
        this.asatz.setBlz(aBLZBank);
    }

    public long getABLZBank() {
        return this.asatz.getBlz();
    }

    public void setAKundenname(String aKundenname) throws DtausException {
        this.asatz.setKundenname(aKundenname);
    }

    public String getAKundenname() {
        return this.asatz.getKundenname();
    }

    public void setADatum(String aDatum) {
        this.asatz.setDateierstellungsdatum(aDatum);
    }

    public void setADatum(Date aDatum) {
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
        this.setADatum(sdf.format(aDatum));
    }

    public void setAKonto(long aKonto) {
        this.asatz.setKonto(aKonto);
    }

    public long getAKonto() {
        return this.asatz.getKonto();
    }

    public void setAAusfuehrungsdatum(Date aAusfuehrungsdatum) {
        this.asatz.setAusfuehrungsdatum(aAusfuehrungsdatum);
    }

    public void setCBLZErstbeteiligtesInstitut(long value) throws DtausException {
        this.csatz.setBlzErstbeteiligt(value);
    }

    public void setCBLZEndbeguenstigt(long value) throws DtausException {
        this.csatz.setBlzEndbeguenstigt(value);
    }

    public long getCBLZEndbeguenstigt() {
        return this.csatz.getBlzEndbeguenstigt();
    }

    public void setCKonto(long cKonto) throws DtausException {
        this.csatz.setKontonummer(cKonto);
    }

    public long getCKonto() {
        return this.csatz.getKontonummer();
    }

    public void setCTextschluessel(int value) throws DtausException {
        this.csatz.setTextschluessel(value);
    }

    public void setCBetragInCent(long cBetragInCent) throws DtausException {
        this.csatz.setBetragInCent(cBetragInCent);
    }

    public void setCBetragInEuro(double value) throws DtausException {
        this.csatz.setBetragInEuro(value);
    }

    public double getCBetragInEuro() {
        return this.csatz.getBetragInEuro();
    }

    public void setCName(String value) throws DtausException {
        this.csatz.setNameEmpfaenger(value);
    }

    public void setCName2(String value) throws DtausException {
        this.csatz.setNameEmpfaenger2(value);
    }

    public void setCInterneKundennummer(long value) throws DtausException {
        this.csatz.setInterneKundennummer(value);
    }

    public void addCVerwendungszweck(String value) throws DtausException {
        this.csatz.addVerwendungszweck(value);
    }

    public void writeASatz() throws Exception {
        this.asatz.write(this.dos);
    }

    public String writeCSatz() throws IOException, DtausException {
        this.csatz.setNameAbsender(this.asatz.getKundenname());
        this.csatz.setErstbeauftragtesInstitut(this.asatz.getBlz());
        this.csatz.setKontoAuftraggeber(this.asatz.getKonto());
        this.esatz.add(this.csatz);
        this.csatz.write(this.dos);
        String ret = this.csatz.toString();
        this.csatz = new CSatz();
        return ret;
    }

    public void writeESatz() throws IOException {
        this.esatz.write(this.dos);
    }

    public long getAnzahlSaetze() {
        return this.esatz.getAnzahlDatensaetze();
    }

    public BigInteger getSummeKontonummern() {
        return this.esatz.getSummeKontonummern();
    }

    public BigInteger getSummeBankleitzahlen() {
        return this.esatz.getSummeBankleitzahlen();
    }

    public BigInteger getSummeBetraege() {
        return this.esatz.getSummeBetraege();
    }

    public BigDecimal getSummeBetraegeDecimal() {
        return new BigDecimal(this.esatz.getSummeBetraege()).divide(new BigDecimal(100));
    }
}

