/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.Dtaus;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import de.jost_net.OBanToo.Dtaus.CSatz;
import de.jost_net.OBanToo.Dtaus.DtausDateiParser;
import de.jost_net.OBanToo.Dtaus.DtausException;
import de.jost_net.OBanToo.Dtaus.HeaderFooter;
import de.jost_net.OBanToo.Tools.Util;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Dtaus2Pdf {
    public Dtaus2Pdf(String dtausfile, String pdffile) throws IOException, DtausException, DocumentException {
        DtausDateiParser in = new DtausDateiParser(dtausfile);
        Document doc = new Document();
        FileOutputStream out = new FileOutputStream(pdffile);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
        doc.setMargins(80.0f, 30.0f, 20.0f, 30.0f);
        doc.addAuthor("OBanToo");
        doc.addTitle("DTAUS2PDF");
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        String fuss = "Ausgegeben am " + sdf.format(new Date()) + "           Seite:  ";
        HeaderFooter hf = new HeaderFooter();
        hf.setFooter(fuss);
        writer.setPageEvent((PdfPageEvent)hf);
        doc.open();
        Paragraph pTitle = new Paragraph("DTAUS-Datei", FontFactory.getFont((String)"Helvetica-Bold", (float)13.0f));
        pTitle.setAlignment(1);
        int anzlogdat = in.getAnzahlLogischerDateien();
        for (int i = 1; i <= anzlogdat; ++i) {
            in.setLogischeDatei(i);
            this.outputASatz(in, doc, i);
            PdfPTable table = new PdfPTable(5);
            float[] widths = new float[]{120.0f, 120.0f, 60.0f, 20.0f, 50.0f};
            table.setWidths(widths);
            table.setWidthPercentage(100.0f);
            table.setSpacingBefore(10.0f);
            table.setSpacingAfter(0.0f);
            String empfzahl = "";
            empfzahl = in.getASatz().getGutschriftLastschrift().startsWith("L") ? "Zahlungspflichtiger" : "Empf\u00e4nger";
            table.addCell(this.getDetailCell(empfzahl, 1, BaseColor.LIGHT_GRAY));
            table.addCell(this.getDetailCell("Verwendungszweck", 1, BaseColor.LIGHT_GRAY));
            table.addCell(this.getDetailCell("Bankverbindung", 1, BaseColor.LIGHT_GRAY));
            table.addCell(this.getDetailCell("Schl.", 1, BaseColor.LIGHT_GRAY));
            table.addCell(this.getDetailCell("Betrag", 2, BaseColor.LIGHT_GRAY));
            table.setHeaderRows(1);
            CSatz c = in.next();
            while (c != null) {
                String name = c.getNameEmpfaenger();
                if (c.getInterneKundennummer() > 0L) {
                    name = name + "\n" + c.getInterneKundennummer();
                }
                table.addCell(this.getDetailCell(name, 0));
                String vzweck = "";
                for (int i2 = 1; i2 <= c.getAnzahlVerwendungszwecke(); ++i2) {
                    vzweck = vzweck + c.getVerwendungszweck(i2);
                    if (i2 >= c.getAnzahlVerwendungszwecke()) continue;
                    vzweck = vzweck + "\n";
                }
                table.addCell(this.getDetailCell(vzweck, 0));
                table.addCell(this.getDetailCell(c.getBlzEndbeguenstigt() + "\n" + c.getKontonummer(), 0));
                table.addCell(this.getDetailCell(c.getTextschluessel() + "", 0));
                table.addCell(this.getDetailCell(Util.formatCurrency(c.getBetragInEuro()), 2));
                c = in.next();
            }
            doc.add((Element)table);
            this.outputESatz(in, doc);
        }
        doc.close();
        out.close();
    }

    private void outputASatz(DtausDateiParser in, Document doc, int logischeDatei) throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        float[] widths = new float[]{200.0f, 170.0f};
        table.setWidths(widths);
        table.setWidthPercentage(65.0f);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(0.0f);
        table.setHorizontalAlignment(2);
        table.addCell(this.getDetailCell("Logische Datei", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(logischeDatei + "", 0));
        table.addCell(this.getDetailCell("Kundenname", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getASatz().getKundenname(), 0));
        table.addCell(this.getDetailCell("BLZ", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getASatz().getBlz() + "", 0));
        table.addCell(this.getDetailCell("Konto", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getASatz().getKonto() + "", 0));
        table.addCell(this.getDetailCell("Gutschrift (G)/Lastschrift(L)/Bank(B)/Kunde(K)", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getASatz().getGutschriftLastschrift(), 0));
        table.addCell(this.getDetailCell("Ausf\u00fchrungsdatum", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getASatz().getAusfuehrungsdatumString(), 0));
        table.addCell(this.getDetailCell("Erstellungsdatum", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getASatz().getDateierstellungsdatum(), 0));
        doc.add((Element)table);
    }

    private void outputESatz(DtausDateiParser in, Document doc) throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        float[] widths = new float[]{150.0f, 200.0f};
        table.setWidths(widths);
        table.setWidthPercentage(60.0f);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(0.0f);
        table.setHorizontalAlignment(2);
        table.addCell(this.getDetailCell("Summe Betr\u00e4ge", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(Util.formatCurrency(in.getESatz().getSummeBetraege().doubleValue() / 100.0), 2));
        table.addCell(this.getDetailCell("Anzahl Datens\u00e4tze", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getESatz().getAnzahlDatensaetze() + "", 2));
        table.addCell(this.getDetailCell("Summe Bankleitzahlen", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getESatz().getSummeBankleitzahlen() + "", 2));
        table.addCell(this.getDetailCell("Summe Kontonummern", 2, BaseColor.LIGHT_GRAY));
        table.addCell(this.getDetailCell(in.getESatz().getSummeKontonummern() + "", 2));
        doc.add((Element)table);
    }

    private PdfPCell getDetailCell(String text, int align) {
        return this.getDetailCell(text, align, BaseColor.WHITE);
    }

    private PdfPCell getDetailCell(String text, int align, BaseColor backgroundcolor) {
        PdfPCell cell = new PdfPCell(new Phrase(this.notNull(text), FontFactory.getFont((String)"Helvetica", (float)8.0f)));
        cell.setHorizontalAlignment(align);
        cell.setBackgroundColor(backgroundcolor);
        return cell;
    }

    private String notNull(String text) {
        return text == null ? "" : text;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: java -cp ... de.jost_net.OBanToo.Dtaus dtausfile pdffile");
            System.exit(1);
        }
        try {
            new Dtaus2Pdf(args[0], args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
        catch (DtausException e) {
            e.printStackTrace();
            System.exit(3);
        }
        catch (DocumentException e) {
            e.printStackTrace();
            System.exit(4);
        }
    }
}

