/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.Dtaus;

import de.jost_net.OBanToo.Dtaus.DtausException;
import de.jost_net.OBanToo.Dtaus.Satz;
import de.jost_net.OBanToo.Dtaus.Tool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Vector;

public class CSatz
extends Satz {
    public static final int TS_LASTSCHRIFT_ABBUCHUNGSVERFAHREN = 4000;
    public static final int TS_LASTSCHRIFT_EINZUGSERMAECHTIGUNGSVERFAHREN = 5000;
    public static final int TS_LASTSCHRIFT_EC_CASH = 5005;
    public static final int TS_LASTSCHRIFT_EC_CASH_AUSLAND = 5006;
    public static final int TS_LASTSCHRIFT_KREDITKARTE = 5008;
    public static final int TS_LASTSCHRIFT_POS = 2573;
    public static final int TS_BANK_09 = 9000;
    public static final int TS_UEBERWEISUNGSGUTSCHRIFT = 51000;
    public static final int TS_UEBERWEISUNG_LOHN_GEHALT_RENTE = 53000;
    public static final int TS_UEBERWEISUNG_OEFFENTL_KASSEN = 56000;
    public static final int TS_BANK_59 = 59000;
    public static final int TS_BANK_67 = 67000;
    public static final int TS_BANK_68 = 68000;
    public static final int TS_BANK_69 = 69000;
    private int cSatzlaenge = 0;
    private String cSatzart = "C";
    private long cBlzErstbeteiligt = 0L;
    private long cBlzEndbeguenstigt = 0L;
    private boolean cBlzEndbeguenstigtSet = false;
    private long cKonto = 0L;
    private boolean cKontoSet = false;
    private long cInterneKundennummer = 0L;
    private boolean cInterneKundennummerSet = false;
    private int cTextschluessel;
    private boolean cTextschluesselSet = false;
    private long cErstbeauftragtesInstitut = 0L;
    private boolean cErstbeauftragtesInstitutSet = false;
    private long cKontoAuftraggeber = 0L;
    private boolean cKontoAuftraggeberSet = false;
    private long cBetrag = 0L;
    private boolean cBetragSet = false;
    private String cNameEmpfaenger = null;
    private boolean cNameEmpfaengerSet = false;
    private String cNameAbsender = null;
    private boolean cNameAbsenderSet = false;
    private Vector<String> cVerwendungszweck = null;
    private boolean cVerwendungszweckSet = false;
    private String cNameEmpfaenger2 = null;
    private String cNameAbsender2 = null;
    private String cWaehrungskennzeichen;
    private int cErweiterungszeichen = 0;
    private Vector<String> cErweiterungsteile = null;

    public CSatz() {
        this.init();
    }

    public CSatz(String satz, int toleranz) throws DtausException {
        satz = this.codingFromDtaus(satz, toleranz);
        this.init();
        this.checkSatzlaengenfeld(satz.substring(0, 4));
        if (!satz.substring(4, 5).equals(this.cSatzart)) {
            throw new DtausException("Satzart des C-Satzes fehlerhaft: ", satz.substring(4, 5));
        }
        this.setBlzErstbeteiligt(satz.substring(5, 13));
        this.setBlzEndbeguenstigt(satz.substring(13, 21));
        this.setKontonummer(satz.substring(21, 31));
        this.setInterneKundennummer(satz.substring(32, 44));
        this.setTextschluessel(satz.substring(44, 49));
        this.setErstbeauftragtesInstitut(satz.substring(61, 69));
        this.setKontoAuftraggeber(satz.substring(69, 79));
        this.setBetragInCent(satz.substring(79, 90));
        this.setNameEmpfaenger(satz.substring(93, 120));
        this.setNameAbsender(satz.substring(128, 155));
        this.addVerwendungszweck(satz.substring(155, 182));
        this.setCWaehrungskennzeichen(satz.substring(182, 183));
        this.setErweiterungskennzeichen(satz.substring(185, 187));
        if (this.getSatzlaenge() != 187 + this.getErweiterungszeichen() * 29) {
            throw new DtausException("Satzlaengenfeld des C-Satzes fehlerhaft: ", satz.substring(0, 4));
        }
        int[] pos = new int[]{187, 216, 256, 285, 314, 343, 384, 413, 442, 471, 512, 541, 570, 599};
        for (int i = 0; i < this.getErweiterungszeichen(); ++i) {
            int p = pos[i];
            this.addErweiterung(satz.substring(p, p + 29));
        }
    }

    private void init() {
        this.cVerwendungszweck = new Vector();
    }

    private void checkSatzlaengenfeld(String value) throws DtausException {
        try {
            this.cSatzlaenge = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new DtausException("Satzlaengenfeld des C-Satzes fehlerhaft: ", value);
        }
        if (this.cSatzlaenge < 187 || this.cSatzlaenge > 622) {
            throw new DtausException("Satzlaengenfeld des C-Satzes fehlerhaft: ", value);
        }
    }

    public int getSatzlaenge() {
        return this.cSatzlaenge;
    }

    public void setBlzErstbeteiligt(String value) throws DtausException {
        try {
            this.setBlzErstbeteiligt(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new DtausException("Bankleitzahl des erstbeteiligten Institutes fehlerhaft: ", value);
        }
    }

    public void setBlzErstbeteiligt(long value) throws DtausException {
        if (value < 0L || value > 99999999L) {
            throw new DtausException("Bankleitzahl des erstbeteiligten Institutes fehlerhaft: ", value + "");
        }
        this.cBlzErstbeteiligt = value;
    }

    public long getBlzErstbeteiligt() {
        return this.cBlzErstbeteiligt;
    }

    public void setBlzEndbeguenstigt(String value) throws DtausException {
        try {
            this.setBlzEndbeguenstigt(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new DtausException("Bankleitzahl des endbeg\u00fcnstigten Institutes fehlerhaft: ", value);
        }
    }

    public void setBlzEndbeguenstigt(long value) throws DtausException {
        if (value <= 0L || value >= 99999999L) {
            throw new DtausException("Bankleitzahl des endbeg\u00fcnstigten Institutes fehlerhaft: ");
        }
        this.cBlzEndbeguenstigt = value;
        this.cBlzEndbeguenstigtSet = true;
    }

    public long getBlzEndbeguenstigt() {
        return this.cBlzEndbeguenstigt;
    }

    public void setKontonummer(String value) throws DtausException {
        try {
            this.setKontonummer(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new DtausException("Kontonummer fehlerhaft: ", value);
        }
    }

    public void setKontonummer(long value) throws DtausException {
        if (value < 0L || value > 9999999999L) {
            throw new DtausException("Kontonummer fehlerhaft: ");
        }
        this.cKonto = value;
        this.cKontoSet = true;
    }

    public long getKontonummer() {
        return this.cKonto;
    }

    public void setInterneKundennummer(String value) throws DtausException {
        try {
            this.setInterneKundennummer(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new DtausException("Interne Kundennummer fehlerhaft: ", value);
        }
    }

    public void setInterneKundennummer(long value) throws DtausException {
        if (value < 0L) {
            throw new DtausException("Interne Kundennummer fehlerhaft: ", value + "");
        }
        this.cInterneKundennummer = value;
        this.cInterneKundennummerSet = true;
    }

    public long getInterneKundennummer() {
        return this.cInterneKundennummer;
    }

    public void setTextschluessel(String value) throws DtausException {
        try {
            this.setTextschluessel(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new DtausException("Textschluessel fehlerhaft: ", value);
        }
    }

    public void setTextschluessel(int value) throws DtausException {
        DecimalFormat df = new DecimalFormat("00000");
        String valueStr = df.format(value);
        String textschluesselStr = valueStr.substring(0, 2);
        int textschluessel = Integer.parseInt(textschluesselStr);
        String textschluesselergaenzungStr = valueStr.substring(2);
        int textschluesselergaenzung = Integer.parseInt(textschluesselergaenzungStr);
        boolean zul\u00e4ssig = false;
        if (textschluessel == 1) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 2) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 3 && textschluesselergaenzung == 0) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 4) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 444 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 5) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 1 || textschluesselergaenzung == 2 || textschluesselergaenzung == 3 || textschluesselergaenzung == 4 || textschluesselergaenzung == 5 || textschluesselergaenzung == 6 || textschluesselergaenzung == 7 || textschluesselergaenzung == 8 || textschluesselergaenzung == 9 || textschluesselergaenzung == 10 || textschluesselergaenzung == 11 || textschluesselergaenzung == 15 || textschluesselergaenzung == 19 || textschluesselergaenzung == 20 || textschluesselergaenzung == 21 || textschluesselergaenzung == 71 || textschluesselergaenzung == 73 || textschluesselergaenzung == 200 || textschluesselergaenzung == 201 || textschluesselergaenzung == 202 || textschluesselergaenzung == 210 || textschluesselergaenzung == 222 || textschluesselergaenzung == 230 || textschluesselergaenzung == 240 || textschluesselergaenzung == 242 || textschluesselergaenzung == 444 || textschluesselergaenzung == 888 || textschluesselergaenzungStr.length() == 3 && textschluesselergaenzungStr.endsWith("9")) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 9) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 10 && textschluesselergaenzung == 0) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 11) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 12 && textschluesselergaenzung == 0) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 13 && textschluesselergaenzung == 0) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 14) {
            if (textschluesselergaenzung == 1 || textschluesselergaenzung == 2 || textschluesselergaenzung == 3 || textschluesselergaenzung == 5 || textschluesselergaenzung == 6 || textschluesselergaenzung == 7 || textschluesselergaenzung == 8 || textschluesselergaenzung == 9 || textschluesselergaenzung == 10 || textschluesselergaenzung == 11 || textschluesselergaenzung == 12 || textschluesselergaenzung == 13 || textschluesselergaenzung == 84 || textschluesselergaenzung == 85 || textschluesselergaenzung == 86 || textschluesselergaenzung == 87 || textschluesselergaenzung == 88 || textschluesselergaenzung == 89 || textschluesselergaenzung == 999) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 15 && (textschluesselergaenzung == 0 || this.isEUStaat(textschluesselergaenzung))) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 51) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 200 || textschluesselergaenzung == 210 || textschluesselergaenzung == 211 || textschluesselergaenzung == 212 || textschluesselergaenzung == 220 || textschluesselergaenzung == 221 || textschluesselergaenzung == 230 || textschluesselergaenzung == 240 || textschluesselergaenzung == 241 || textschluesselergaenzung == 401 || textschluesselergaenzung == 402 || textschluesselergaenzung == 403 || textschluesselergaenzung == 405 || textschluesselergaenzung == 406 || textschluesselergaenzung == 407 || textschluesselergaenzung == 408 || textschluesselergaenzung == 409 || textschluesselergaenzung == 410 || textschluesselergaenzung == 411 || textschluesselergaenzung == 412 || textschluesselergaenzung == 413 || textschluesselergaenzung == 444 || textschluesselergaenzung == 445 || textschluesselergaenzung == 484 || textschluesselergaenzung == 485 || textschluesselergaenzung == 486 || textschluesselergaenzung == 487 || textschluesselergaenzung == 488 || textschluesselergaenzung == 489 || textschluesselergaenzung == 501 || textschluesselergaenzung == 502 || textschluesselergaenzung == 503 || textschluesselergaenzung == 504 || textschluesselergaenzung == 505 || textschluesselergaenzung == 506 || textschluesselergaenzung == 507 || textschluesselergaenzung == 509 || textschluesselergaenzung == 510 || textschluesselergaenzung == 511 || textschluesselergaenzung == 520 || textschluesselergaenzung == 521 || textschluesselergaenzung == 571 || textschluesselergaenzung == 573 || textschluesselergaenzung == 888 || textschluesselergaenzung == 990 || textschluesselergaenzungStr.length() == 3 && textschluesselergaenzungStr.endsWith("9")) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 52) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 444 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 53) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 444 || textschluesselergaenzung == 445 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 54) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 56) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 444 || textschluesselergaenzung == 445) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 59) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 63 && (textschluesselergaenzung == 0 || this.isEUStaat(textschluesselergaenzung) || this.isNonEUStaat(textschluesselergaenzung))) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 65 && (this.isEUStaat(textschluesselergaenzung) || this.isNonEUStaat(textschluesselergaenzung))) {
            zul\u00e4ssig = true;
        } else if (textschluessel == 67) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 444 || textschluesselergaenzung == 445 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 68) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 444 || textschluesselergaenzung == 445 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 69) {
            if (textschluesselergaenzung == 0 || textschluesselergaenzung == 444 || textschluesselergaenzung == 445 || textschluesselergaenzung == 888) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 81) {
            if (textschluesselergaenzung == 0) {
                zul\u00e4ssig = true;
            }
        } else if (textschluessel == 84 && textschluesselergaenzung == 0) {
            zul\u00e4ssig = true;
        }
        if (!zul\u00e4ssig) {
            throw new DtausException("Textschluessel fehlerhaft: ", valueStr);
        }
        this.cTextschluessel = value;
        this.cTextschluesselSet = true;
    }

    private boolean isEUStaat(int texterweiterung) {
        return texterweiterung == 56 || texterweiterung == 208 || texterweiterung == 246 || texterweiterung == 250 || texterweiterung == 300 || texterweiterung == 826 || texterweiterung == 372 || texterweiterung == 352 || texterweiterung == 380 || texterweiterung == 442 || texterweiterung == 528 || texterweiterung == 578 || texterweiterung == 32 || texterweiterung == 620 || texterweiterung == 752 || texterweiterung == 756;
    }

    private boolean isNonEUStaat(int texterweiterung) {
        return texterweiterung == 888;
    }

    public long getTextschluessel() {
        return this.cTextschluessel;
    }

    public void setErstbeauftragtesInstitut(String value) throws DtausException {
        try {
            this.setErstbeauftragtesInstitut(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new DtausException("Erstbeauftragtes Institut fehlerhaft: ", value);
        }
    }

    public void setErstbeauftragtesInstitut(long value) throws DtausException {
        if (value < 0L) {
            throw new DtausException("Erstbeauftragtes Institut fehlerhaft: ");
        }
        this.cErstbeauftragtesInstitut = value;
        this.cErstbeauftragtesInstitutSet = true;
    }

    public long getErstbeauftragtesInstitut() {
        return this.cErstbeauftragtesInstitut;
    }

    public void setKontoAuftraggeber(String value) throws DtausException {
        try {
            this.setKontoAuftraggeber(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new DtausException("Konto Auftraggeber fehlerhaft: ", value);
        }
    }

    public void setKontoAuftraggeber(long value) throws DtausException {
        if (value < 0L) {
            throw new DtausException("Konto Auftraggeber fehlerhaft: ", value + "");
        }
        this.cKontoAuftraggeber = value;
        this.cKontoAuftraggeberSet = true;
    }

    public long getKontoAuftraggeber() {
        return this.cKontoAuftraggeber;
    }

    public void setBetragInCent(String value) throws DtausException {
        try {
            this.setBetragInCent(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new DtausException("Betrag fehlerhaft: ", value);
        }
    }

    public void setBetragInCent(long value) throws DtausException {
        if (value <= 0L) {
            throw new DtausException("Betrag fehlerhaft: ", value + "");
        }
        this.cBetrag = value;
        this.cBetragSet = true;
    }

    public void setBetragInEuro(double value) throws DtausException {
        BigDecimal bval = new BigDecimal(value + "");
        bval = bval.multiply(new BigDecimal("100"));
        this.setBetragInCent(bval.longValue());
    }

    public long getBetragInCent() {
        return this.cBetrag;
    }

    public double getBetragInEuro() {
        return (double)this.cBetrag / 100.0;
    }

    public void setNameEmpfaenger(String value) throws DtausException {
        if ((value = value.trim()).length() > 27) {
            throw new DtausException("Name des Zahlungsempf\u00e4ngers/Zahlungspflichtigen ung\u00fcltig.");
        }
        this.cNameEmpfaenger = this.makeValid(value);
        try {
            this.validCharacters(this.cNameEmpfaenger);
        }
        catch (DtausException e) {
            throw new DtausException(e.getMessage() + " im Feld NameEmpf\u00e4nger des C-Satzes");
        }
        this.cNameEmpfaengerSet = true;
    }

    public String getNameEmpfaenger() {
        return this.cNameEmpfaenger;
    }

    public void setNameEmpfaenger2(String value) throws DtausException {
        if ((value = value.trim()).length() > 27) {
            throw new DtausException("Name(2) des Zahlungsempf\u00e4ngers/Zahlungspflichtigen ung\u00fcltig.", value);
        }
        this.cNameEmpfaenger2 = this.makeValid(value);
        try {
            this.validCharacters(this.cNameEmpfaenger2);
        }
        catch (DtausException e) {
            throw new DtausException(e.getMessage() + " im Feld NameEmpf\u00e4nger2 des C-Satzes");
        }
    }

    public String getNameEmpfaenger2() {
        return this.cNameEmpfaenger2;
    }

    public void setNameAbsender(String value) throws DtausException {
        if ((value = value.trim()).length() > 27) {
            throw new DtausException("Name des Absenders ung\u00fcltig.");
        }
        this.cNameAbsender = this.makeValid(value);
        try {
            this.validCharacters(this.cNameAbsender);
        }
        catch (DtausException e) {
            throw new DtausException(e.getMessage() + " im Feld NameAbsender des C-Satzes");
        }
        this.cNameAbsenderSet = true;
    }

    public String getNameAbsender() {
        return this.cNameAbsender;
    }

    public void setNameAbsender2(String value) throws DtausException {
        if ((value = value.trim()).length() > 27) {
            throw new DtausException("Name(2) des Absenders ung\u00fcltig.");
        }
        this.cNameAbsender2 = this.makeValid(value);
        try {
            this.validCharacters(this.cNameAbsender2);
        }
        catch (DtausException e) {
            throw new DtausException(e.getMessage() + " im Feld NameAbsender2 des C-Satzes");
        }
    }

    public String getNameAbsender2() {
        return this.cNameAbsender2;
    }

    public String getCWaehrungskennzeichen() {
        return this.cWaehrungskennzeichen;
    }

    public void setCWaehrungskennzeichen(String value) {
        this.cWaehrungskennzeichen = value;
    }

    public void addVerwendungszweck(String value) throws DtausException {
        if ((value = value.trim()).length() > 27) {
            throw new DtausException("Verwendungszweck fehlerhaft (L\u00e4nge > 27) oder mehr als 13 St\u00fcck.", value);
        }
        String vzw = this.makeValid(value);
        try {
            this.validCharacters(vzw);
        }
        catch (DtausException e) {
            throw new DtausException(e.getMessage() + " im Verwendungszweck des C-Satzes");
        }
        this.cVerwendungszweck.addElement(vzw);
        this.cVerwendungszweckSet = true;
    }

    public String getVerwendungszweck(int nr) {
        if (nr <= this.getAnzahlVerwendungszwecke()) {
            return this.cVerwendungszweck.elementAt(nr - 1);
        }
        return null;
    }

    private String getErweiterungsteil(int nr) {
        if (nr <= this.cErweiterungszeichen) {
            return this.cErweiterungsteile.elementAt(nr - 1);
        }
        return null;
    }

    public int getAnzahlVerwendungszwecke() {
        return this.cVerwendungszweck.size();
    }

    public void setErweiterungskennzeichen(String value) throws DtausException {
        try {
            this.cErweiterungszeichen = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new DtausException("Erweiterungszeichen fehlerhaft: ", value);
        }
    }

    public int getErweiterungszeichen() {
        return this.cErweiterungszeichen;
    }

    public void addErweiterung(String value) throws DtausException {
        String val = value.substring(2).trim();
        val = this.makeValid(val);
        try {
            this.validCharacters(val);
        }
        catch (DtausException e) {
            throw new DtausException(e.getMessage() + " im Erweiterungsteil des C-Satzes");
        }
        if (value.startsWith("02")) {
            this.addVerwendungszweck(val);
        } else if (value.startsWith("01")) {
            this.setNameEmpfaenger2(val);
        } else if (value.startsWith("03")) {
            this.setNameAbsender2(val);
        } else {
            throw new DtausException("Erweiterung fehlerhaft: ", value);
        }
    }

    public void write(DataOutputStream dos) throws IOException, DtausException {
        if (!this.isOK()) {
            throw new DtausException("Nicht alle C-Satz-Daten gef\u00fcllt.");
        }
        this.cErweiterungszeichen = this.cVerwendungszweck.size() - 1;
        if (this.cNameEmpfaenger2 != null) {
            ++this.cErweiterungszeichen;
        }
        if (this.cNameAbsender2 != null) {
            ++this.cErweiterungszeichen;
        }
        dos.writeBytes(Tool.formatSL(187 + this.cErweiterungszeichen * 29));
        dos.writeBytes("C");
        dos.writeBytes(Tool.formatBLZ(this.cBlzErstbeteiligt));
        dos.writeBytes(Tool.formatBLZ(this.cBlzEndbeguenstigt));
        dos.writeBytes(Tool.formatKonto(this.cKonto));
        dos.writeBytes("0000000000000");
        dos.writeBytes(Tool.formatTextschluessel(this.cTextschluessel));
        dos.writeBytes(" ");
        DecimalFormat dfBetrag = new DecimalFormat("00000000000");
        dos.writeBytes(dfBetrag.format(0L));
        dos.writeBytes(Tool.formatBLZ(this.cErstbeauftragtesInstitut));
        dos.writeBytes(Tool.formatKonto(this.cKontoAuftraggeber));
        dos.writeBytes(dfBetrag.format(this.cBetrag));
        dos.writeBytes(Tool.space(3));
        dos.writeBytes(this.make27(this.cNameEmpfaenger));
        dos.writeBytes(Tool.space(8));
        dos.writeBytes(this.make27(this.cNameAbsender));
        dos.writeBytes(this.make27(this.getVerwendungszweck(1)));
        dos.writeBytes("1");
        dos.writeBytes(Tool.space(2));
        this.cErweiterungsteile = new Vector();
        if (this.cNameEmpfaenger2 != null) {
            this.cErweiterungsteile.addElement("01" + this.make27(this.getNameEmpfaenger2()));
        }
        for (int i = 2; i <= this.getAnzahlVerwendungszwecke(); ++i) {
            this.cErweiterungsteile.addElement("02" + this.make27(this.getVerwendungszweck(i)));
        }
        if (this.cNameAbsender2 != null) {
            this.cErweiterungsteile.addElement("03" + this.make27(this.getNameAbsender2()));
        }
        dos.writeBytes(Tool.formatErweiterung(this.cErweiterungszeichen));
        if (this.cErweiterungszeichen >= 1) {
            dos.writeBytes(this.getErweiterungsteil(1));
        } else {
            dos.writeBytes(Tool.space(29));
        }
        if (this.cErweiterungszeichen >= 2) {
            dos.writeBytes(this.getErweiterungsteil(2));
        } else {
            dos.writeBytes(Tool.space(29));
        }
        dos.writeBytes(Tool.space(11));
        this.ausgebenErweiterungsteile(dos, 3);
        this.ausgebenErweiterungsteile(dos, 7);
        this.ausgebenErweiterungsteile(dos, 11);
    }

    private void ausgebenErweiterungsteile(DataOutputStream dos, int pos) throws IOException {
        if (this.cErweiterungszeichen >= pos) {
            for (int i = pos; i < pos + 4; ++i) {
                String vzweck = this.getErweiterungsteil(i);
                if (vzweck != null) {
                    dos.writeBytes(vzweck);
                    continue;
                }
                dos.writeBytes(Tool.space(29));
            }
            dos.writeBytes(Tool.space(12));
        }
    }

    public boolean isOK() throws DtausException {
        if (!this.cBlzEndbeguenstigtSet) {
            throw new DtausException("Bankleitzahl des endbeg\u00fcnstigten Institutes fehlerhaft: ");
        }
        if (!this.cKontoSet) {
            throw new DtausException("Kontonummer fehlerhaft: ");
        }
        if (!this.cInterneKundennummerSet) {
            throw new DtausException("Interne Kundennummer fehlerhaft: ");
        }
        if (!this.cTextschluesselSet) {
            throw new DtausException("Textschluessel fehlerhaft: ");
        }
        if (!this.cErstbeauftragtesInstitutSet) {
            throw new DtausException("Bankleitzahl des erstbeteiligten Institutes fehlerhaft: ");
        }
        if (!this.cKontoAuftraggeberSet) {
            throw new DtausException("Konto Auftraggeber fehlerhaft: ");
        }
        if (!this.cBetragSet) {
            throw new DtausException("Betrag fehlerhaft: ");
        }
        if (!this.cNameEmpfaengerSet) {
            throw new DtausException("Name des Zahlungsempf\u00e4ngers/Zahlungspflichtigen ung\u00fcltig.");
        }
        if (!this.cNameAbsenderSet) {
            throw new DtausException("Name des Absenders ung\u00fcltig.");
        }
        if (!this.cVerwendungszweckSet) {
            throw new DtausException("Verwendungszweck fehlerhaft (L\u00e4nge > 27) oder mehr als 13 St\u00fcck.");
        }
        return true;
    }

    public String toString() {
        String ret = "Satzl\u00e4nge=" + this.getSatzlaenge() + ", BLZ erstbeteiligt=" + this.getBlzErstbeteiligt() + ", BLZ endbeg\u00fcnstigt=" + this.getBlzEndbeguenstigt() + ", Kontonummer=" + this.getKontonummer() + ", interne Kundennummer=" + this.getInterneKundennummer() + ", Textschluessel=" + this.getTextschluessel() + ", erstbeauftragtes Institut=" + this.getErstbeauftragtesInstitut() + ", Konto Auftraggeber=" + this.getKontoAuftraggeber() + ", Betrag=" + this.getBetragInCent() + ", Name Empf\u00e4nger=" + this.getNameEmpfaenger() + ", Name Empf\u00e4nger2=" + this.getNameEmpfaenger2() + ", Name Absender=" + this.getNameAbsender() + ", Name Absender2=" + this.getNameAbsender2() + ", Erweiterungszeichen=" + this.getErweiterungszeichen();
        for (int i = 1; i <= this.getAnzahlVerwendungszwecke(); ++i) {
            ret = ret + ", Verwendungszweck[" + i + "]=" + this.getVerwendungszweck(i);
        }
        return ret;
    }

    public static void main(String[] args) throws DtausException {
        CSatz c = new CSatz();
        c.setTextschluessel("53009");
    }
}

