/*
 * Decompiled with CFR 0.152.
 */
package de.jost_net.OBanToo.Dtaus;

import de.jost_net.OBanToo.Dtaus.DtausException;
import de.jost_net.OBanToo.Dtaus.Satz;
import de.jost_net.OBanToo.Dtaus.Tool;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ASatz
extends Satz {
    private String aSatzlaenge = "0128";
    private String aSatzart = "A";
    private String aGutschriftLastschrift = null;
    private long aBlz = 0L;
    private long aFeld5;
    private String aKundenname = null;
    private String aDateierstellungsdatum = null;
    private long aKonto = 0L;
    private String aReferenz = "          ";
    private Date aAusfuehrungsdatum = null;
    private String aWaehrungskennzeichen = "1";
    private int toleranz = 0;

    public ASatz(String satz, int toleranz) throws DtausException {
        this.toleranz = toleranz;
        satz = this.codingFromDtaus(satz, toleranz);
        try {
            this.validCharacters(satz);
        }
        catch (DtausException e) {
            throw new DtausException(e.getMessage() + " im A-Satz");
        }
        if (!satz.substring(0, 4).equals(this.aSatzlaenge)) {
            throw new DtausException("Satzl\u00e4ngenfeld des A-Satzes fehlerhaft: ");
        }
        if (!satz.substring(4, 5).equals(this.aSatzart)) {
            throw new DtausException("Satzart des A-Satzes fehlerhaft: ");
        }
        this.setGutschriftLastschrift(satz.substring(5, 7));
        this.setBlz(satz.substring(7, 15));
        this.setFeld5(satz.substring(15, 23));
        this.setKundenname(satz.substring(23, 50));
        this.setDateierstellungsdatum(satz.substring(50, 56));
        this.setKonto(satz.substring(60, 70));
        this.setReferenz(satz.substring(70, 80));
        this.setAusfuehrungsdatum(satz.substring(95, 103));
        this.setWaehrungskennzeichen(satz.substring(127, 128));
    }

    public ASatz() {
    }

    public void setGutschriftLastschrift(String value) throws DtausException {
        if (!(value.equals("GK") || value.equals("LK") || value.equals("GB") || value.equals("LB"))) {
            throw new DtausException("Gutschrift/Lastschrift-Kennzeichen des A-Satzes fehlerhaft: ");
        }
        this.aGutschriftLastschrift = value;
    }

    public String getGutschriftLastschrift() {
        return this.aGutschriftLastschrift;
    }

    public void setBlz(String value) throws DtausException {
        try {
            this.aBlz = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new DtausException("Bankleitzahl des A-Satzes fehlerhaft: ");
        }
    }

    public void setBlz(long value) {
        this.aBlz = value;
    }

    public long getBlz() {
        return this.aBlz;
    }

    public void setFeld5(String value) {
        try {
            this.aFeld5 = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            this.aFeld5 = 0L;
        }
    }

    public void setFeld5(long value) {
        this.aFeld5 = value;
    }

    public long getFeld5() {
        return this.aFeld5;
    }

    public void setKundenname(String value) throws DtausException {
        this.aKundenname = this.makeValid(value);
        this.validCharacters(this.aKundenname);
    }

    public String getKundenname() {
        return this.aKundenname;
    }

    public void setDateierstellungsdatum(String value) {
        this.aDateierstellungsdatum = value;
    }

    public String getDateierstellungsdatum() {
        return this.aDateierstellungsdatum;
    }

    public Date getDateierstellungsdatumAlsDatum() {
        Date erstellungsDatum;
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyy");
        try {
            erstellungsDatum = sdf.parse(this.aDateierstellungsdatum);
        }
        catch (ParseException e) {
            erstellungsDatum = null;
        }
        return erstellungsDatum;
    }

    public void setKonto(String value) throws DtausException {
        try {
            this.aKonto = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new DtausException("Konto des A-Satzes fehlerhaft: ", value);
        }
    }

    public void setKonto(long value) {
        this.aKonto = value;
    }

    public long getKonto() {
        return this.aKonto;
    }

    public void setReferenz(String value) {
        this.aReferenz = value;
    }

    public String getReferenz() {
        return this.aReferenz;
    }

    public void setAusfuehrungsdatum(String value) throws DtausException {
        if (value.equals("        ")) {
            this.aAusfuehrungsdatum = null;
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
        try {
            this.aAusfuehrungsdatum = sdf.parse(value);
        }
        catch (ParseException e) {
            throw new DtausException("Ausf\u00fchrungsdatum fehlerhaft");
        }
    }

    public void setAusfuehrungsdatum(Date value) {
        this.aAusfuehrungsdatum = value;
    }

    public String getAusfuehrungsdatumString() {
        SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
        try {
            return sdf.format(this.aAusfuehrungsdatum);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public Date getAusfuehrungsdatum() {
        return this.aAusfuehrungsdatum;
    }

    public void setWaehrungskennzeichen(String value) throws DtausException {
        if (value.equals("1")) {
            this.aWaehrungskennzeichen = value;
        } else if ((this.toleranz & 4) == 4) {
            System.out.println("W\u00e4hrungskennzeichen des A-Satzes fehlerhaft: " + value);
        } else {
            throw new DtausException("W\u00e4hrungskennzeichen des A-Satzes fehlerhaft: ", value);
        }
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeBytes("0128");
        dos.writeBytes("A");
        dos.writeBytes(this.aGutschriftLastschrift);
        dos.writeBytes(Tool.formatBLZ(this.aBlz));
        if (this.aFeld5 != 0L) {
            dos.writeBytes(Long.toString(this.aFeld5));
        } else {
            dos.writeBytes("00000000");
        }
        dos.writeBytes(this.make27(this.aKundenname));
        if (this.aDateierstellungsdatum != null) {
            dos.writeBytes(this.aDateierstellungsdatum);
        } else {
            dos.writeBytes(Tool.space(6));
        }
        dos.writeBytes(Tool.space(4));
        DecimalFormat dfKonto = new DecimalFormat("0000000000");
        dos.writeBytes(dfKonto.format(this.aKonto));
        if (this.aReferenz != null) {
            dos.writeBytes(this.aReferenz);
        } else {
            dos.writeBytes("0000000000");
        }
        dos.writeBytes(Tool.space(15));
        if (this.aAusfuehrungsdatum != null) {
            SimpleDateFormat sdf11 = new SimpleDateFormat("ddMMyyyy");
            dos.writeBytes(sdf11.format(this.aAusfuehrungsdatum));
        } else {
            dos.writeBytes(Tool.space(8));
        }
        dos.writeBytes(Tool.space(24));
        dos.writeBytes(this.aWaehrungskennzeichen);
    }

    public String toString() {
        return "Satzlaenge=" + this.aSatzlaenge + ", Satzart=" + this.aSatzart + ", Gutschrift/Lastschrift=" + this.aGutschriftLastschrift + ", BLZ=" + this.aBlz + ", Feld5=" + this.aFeld5 + ", Kundenname=" + this.aKundenname + ", Dateierstellungsdatum=" + this.aDateierstellungsdatum + ", Konto=" + this.aKonto + ", Referenz=" + this.aReferenz + ", Ausf\u00fchrungsdatum=" + this.aAusfuehrungsdatum + ", W\u00e4hrungskennzeichen=" + this.aWaehrungskennzeichen;
    }
}

